/*
 * Decompiled with CFR 0.152.
 */
package com.combatsync;

import com.combatsync.CombatSync;
import com.combatsync.ConfigManager;
import org.bukkit.GameMode;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class CombatListener
implements Listener {
    private final CombatSync plugin;

    public CombatListener(CombatSync plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onEntityDamage(EntityDamageByEntityEvent event) {
        ConfigManager config = this.plugin.getConfigManager();
        if (!config.isEnabled() || !config.isKnockbackEnabled()) {
            return;
        }
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        Player victim = (Player)event.getEntity();
        if (config.isExemptCreative() && victim.getGameMode() == GameMode.CREATIVE) {
            return;
        }
        this.applyKnockbackSync(victim);
    }

    private void applyKnockbackSync(final Player victim) {
        final ConfigManager config = this.plugin.getConfigManager();
        int delay = config.isDelayCompensation() ? Math.max(1, config.getBufferTime() / 50) : 1;
        new BukkitRunnable(){

            public void run() {
                if (!victim.isOnline() || victim.isDead()) {
                    return;
                }
                Vector currentVelocity = victim.getVelocity();
                Vector adjustedVelocity = CombatListener.this.plugin.getKnockbackManager().calculateAdjustedKnockback(victim, currentVelocity);
                if (config.isSyncPackets()) {
                    victim.setVelocity(adjustedVelocity);
                }
            }
        }.runTaskLater((Plugin)this.plugin, (long)delay);
    }
}

