/*
 * Decompiled with CFR 0.152.
 */
package com.zehunz.zehunzcrop.block;

import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2302;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3726;
import net.minecraft.class_4970;

public class CustomCropBlock
extends class_2302 {
    public static final ThreadLocal<class_2758> CURRENT_CONSTRUCTOR_AGE_PROPERTY = new ThreadLocal();
    public static final ThreadLocal<Integer> CURRENT_CONSTRUCTOR_MAX_AGE_VALUE = new ThreadLocal();
    private final class_2758 ageProperty;
    private final int maxAge;
    private final class_265[] shapes;
    private final Supplier<? extends class_1935> seedItem;
    private final boolean fireParticles;
    private final int maxXp;

    public CustomCropBlock(class_4970.class_2251 settings, int maxAge, class_2758 ageProperty, Supplier<? extends class_1935> seedItem, boolean fireParticles, int maxXp) {
        super(settings);
        this.maxAge = maxAge;
        this.ageProperty = ageProperty;
        this.seedItem = seedItem;
        this.fireParticles = fireParticles;
        this.maxXp = maxXp;
        this.method_9590((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)this.ageProperty, (Comparable)Integer.valueOf(0)));
        this.shapes = new class_265[this.maxAge + 1];
        for (int i = 0; i <= this.maxAge; ++i) {
            double height = 2.0 + (double)i * (14.0 / (double)this.maxAge);
            this.shapes[i] = class_259.method_1081((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)(height / 16.0), (double)1.0);
        }
    }

    public class_2758 method_9824() {
        class_2758 tempProperty = CURRENT_CONSTRUCTOR_AGE_PROPERTY.get();
        if (tempProperty != null) {
            return tempProperty;
        }
        if (this.ageProperty != null) {
            return this.ageProperty;
        }
        throw new IllegalStateException("Age property not available. ThreadLocal not set or instance not fully initialized.");
    }

    public int method_9827() {
        Integer tempMaxAge = CURRENT_CONSTRUCTOR_MAX_AGE_VALUE.get();
        if (tempMaxAge != null) {
            return tempMaxAge;
        }
        if (this.maxAge > 0) {
            return this.maxAge;
        }
        throw new IllegalStateException("Max age not available. ThreadLocal not set or instance not fully initialized.");
    }

    protected class_1935 method_9832() {
        return this.seedItem.get();
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{this.method_9824()});
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        int age = Math.min((Integer)state.method_11654((class_2769)this.method_9824()), this.method_9827());
        return this.shapes[age];
    }

    public void randomDisplayTick(class_2680 state, class_1937 world, class_2338 pos, Random random) {
        if (this.fireParticles && ((Integer)state.method_11654((class_2769)this.method_9824())).intValue() == this.method_9827() && random.nextInt(3) == 0) {
            double x = (double)pos.method_10263() + 0.5;
            double y = (double)pos.method_10264() + 1.0;
            double z = (double)pos.method_10260() + 0.5;
            double offsetX = (random.nextDouble() - 0.5) * 0.3;
            double offsetZ = (random.nextDouble() - 0.5) * 0.3;
            world.method_8406((class_2394)class_2398.field_11240, x + offsetX, y, z + offsetZ, 0.0, 0.01, 0.0);
        }
    }

    public void method_9556(class_1937 world, class_1657 player, class_2338 pos, class_2680 state, class_2586 blockEntity, class_1799 tool) {
        super.method_9556(world, player, pos, state, blockEntity, tool);
        if (!world.field_9236 && world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            if (this.maxXp > 0) {
                int xp = serverWorld.method_8409().method_43048(this.maxXp) + 1;
                this.method_9583(serverWorld, pos, xp);
            }
        }
    }

    public static CustomCropBlock createCropBlock(class_4970.class_2251 settings, int maxAge, class_2758 ageProp, Supplier<? extends class_1935> seedSupplier, boolean fire, int xp) {
        CURRENT_CONSTRUCTOR_AGE_PROPERTY.set(ageProp);
        CURRENT_CONSTRUCTOR_MAX_AGE_VALUE.set(maxAge);
        CustomCropBlock block = new CustomCropBlock(settings, maxAge, ageProp, seedSupplier, fire, xp);
        CURRENT_CONSTRUCTOR_AGE_PROPERTY.remove();
        CURRENT_CONSTRUCTOR_MAX_AGE_VALUE.remove();
        return block;
    }
}

