/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown._vanilla;

import ca.bradj.questown.QT;
import ca.bradj.questown._vanilla.VoidLevel;
import ca.bradj.questown.integration.jobs.JobPhaseModifier;
import ca.bradj.questown.integration.minecraft.MCHeldItem;
import ca.bradj.questown.jobs.JobBlockTestContext;
import ca.bradj.questown.mc.Compat;
import java.util.Collection;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import org.jetbrains.annotations.Nullable;

public class CheckTreePlantable
extends JobPhaseModifier {
    @Override
    public boolean postJobBlockCheckPassed(JobBlockTestContext ctx) {
        boolean b = super.postJobBlockCheckPassed(ctx);
        if (!b) {
            return false;
        }
        List<MCHeldItem> items = ctx.townUniqueItems().get().stream().map(MCHeldItem::fromTown).toList();
        SaplingBlock sapling = this.getSapling(items);
        if (sapling == null) {
            sapling = this.getSapling(ctx.heldItems().get());
        }
        if (sapling == null) {
            return false;
        }
        BlockPos above = ctx.blockPos().m_7494_();
        Iterable rg = BlockPos.m_121940_((BlockPos)above.m_7918_(-1, 0, -1), (BlockPos)above.m_7918_(1, 0, 1));
        for (BlockPos pos : rg) {
            if (ctx.level().m_8055_(pos).m_60795_()) continue;
            return false;
        }
        String thisName = this.getClass().getSimpleName();
        ResourceLocation saplingId = Compat.getItemId((Block)sapling);
        String[] idParts = saplingId.m_135815_().split("_sapling");
        if (idParts.length != 1) {
            QT.JOB_LOGGER.error("Attempted to use {} with unconventional sapling ID: {}", (Object)thisName, (Object)saplingId);
            return false;
        }
        String treeId = idParts[0];
        ConfiguredFeature cf = (ConfiguredFeature)BuiltinRegistries.f_123861_.m_7745_(new ResourceLocation("minecraft", treeId));
        if (cf == null && (cf = (ConfiguredFeature)BuiltinRegistries.f_123861_.m_7745_(new ResourceLocation("minecraft", treeId + "_tree"))) == null) {
            QT.JOB_LOGGER.error("Attempted to use {} with non-existent feature: {}", (Object)thisName, (Object)treeId);
            return false;
        }
        Feature feature = cf.f_65377_();
        if (!(feature instanceof TreeFeature)) {
            QT.JOB_LOGGER.error("Attempted to use {} with non-tree feature: {}", (Object)thisName, (Object)treeId);
            return false;
        }
        TreeFeature tree = (TreeFeature)feature;
        FeatureConfiguration featureConfiguration = cf.f_65378_();
        if (!(featureConfiguration instanceof TreeConfiguration)) {
            QT.JOB_LOGGER.error("Attempted to use {} with non-tree configuration: {}", (Object)thisName, (Object)treeId);
            return false;
        }
        TreeConfiguration config = (TreeConfiguration)featureConfiguration;
        ServerLevel level = ctx.level();
        return tree.m_225028_((FeatureConfiguration)config, (WorldGenLevel)new VoidLevel(level), null, level.f_46441_, above);
    }

    @Nullable
    private SaplingBlock getSapling(Collection<MCHeldItem> items) {
        for (MCHeldItem item : items) {
            SaplingBlock townSapling;
            if (item.isEmpty() || (townSapling = this.getSaplingBlock(item.get().toMCItemStack())) == null) continue;
            return townSapling;
        }
        return null;
    }

    @Nullable
    private SaplingBlock getSaplingBlock(ItemStack heldItem) {
        Item item = heldItem.m_41720_();
        if (!(item instanceof BlockItem)) {
            return null;
        }
        BlockItem blockItem = (BlockItem)item;
        Block block = blockItem.m_40614_();
        if (!(block instanceof SaplingBlock)) {
            return null;
        }
        SaplingBlock sb = (SaplingBlock)block;
        return sb;
    }
}

