/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.blocks;

import ca.bradj.questown.blocks.StatefulJobBlock;
import ca.bradj.questown.blocks.TakeFn;
import ca.bradj.questown.core.init.items.ItemsInit;
import ca.bradj.questown.integration.minecraft.MCHeldItem;
import ca.bradj.questown.jobs.Jobs;
import ca.bradj.questown.mc.Compat;
import ca.bradj.questown.town.workstatus.State;
import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class BreadOvenBlock
extends HorizontalDirectionalBlock
implements StatefulJobBlock {
    public static final String ITEM_ID = "bread_oven_block";
    public static final IntegerProperty BAKE_STATE = IntegerProperty.m_61631_((String)"bake_state", (int)0, (int)4);
    private static final int BAKE_STATE_EMPTY = 0;
    private static final int BAKE_STATE_HALF_FILLED = 1;
    private static final int BAKE_STATE_FILLED = 2;
    private static final int BAKE_STATE_BAKING = 3;
    private static final int BAKE_STATE_BAKED = 4;

    public BreadOvenBlock() {
        super(BlockBehaviour.Properties.m_60944_((Material)Material.f_76272_, (MaterialColor)MaterialColor.f_76362_).m_60953_(bs -> (Integer)bs.m_61143_((Property)BAKE_STATE) == 3 ? 10 : 0).m_60913_(1.0f, 10.0f));
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)BAKE_STATE, (Comparable)Integer.valueOf(0))).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH));
    }

    public static boolean canAcceptWheat(BlockState oldState) {
        if (!oldState.m_61138_((Property)BAKE_STATE)) {
            return false;
        }
        return (Integer)oldState.m_61143_((Property)BAKE_STATE) < 2;
    }

    public static boolean canAcceptCoal(BlockState oldState) {
        if (!oldState.m_61138_((Property)BAKE_STATE)) {
            return false;
        }
        return (Integer)oldState.m_61143_((Property)BAKE_STATE) == 2;
    }

    public static boolean isBaking(BlockState oldState) {
        if (!oldState.m_61138_((Property)BAKE_STATE)) {
            return false;
        }
        return (Integer)oldState.m_61143_((Property)BAKE_STATE) == 3;
    }

    public static boolean hasBread(BlockState oldState) {
        if (!oldState.m_61138_((Property)BAKE_STATE)) {
            return false;
        }
        return (Integer)oldState.m_61143_((Property)BAKE_STATE) == 4;
    }

    public static BlockState extractBread(BlockState oldState, ServerLevel sl, BlockPos block, @Nullable TakeFn takeFn) {
        BlockState bs = (BlockState)oldState.m_61124_((Property)BAKE_STATE, (Comparable)Integer.valueOf(0));
        sl.m_7731_(block, bs, 11);
        BreadOvenBlock.moveBreadToWorld(sl, block, takeFn);
        return bs;
    }

    private static void moveBreadToWorld(ServerLevel level, BlockPos b, @Nullable TakeFn takeFn) {
        MCHeldItem is = MCHeldItem.fromMCItemStack(new ItemStack((ItemLike)Items.f_42406_, 1));
        Jobs.getOrCreateItemFromBlock(level, b, takeFn, is, false);
        level.m_7731_(b, (BlockState)level.m_8055_(b).m_61124_((Property)BAKE_STATE, (Comparable)Integer.valueOf(0)), 11);
    }

    public List<ItemStack> m_7381_(BlockState p_60537_, LootContext.Builder p_60538_) {
        return ImmutableList.of((Object)((Item)ItemsInit.BREAD_OVEN_BLOCK.get()).m_7968_());
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        BlockState blockState = (BlockState)this.m_49966_().m_61124_((Property)BAKE_STATE, (Comparable)Integer.valueOf(0));
        Level level = ctx.m_43725_();
        if (!(level instanceof ServerLevel)) {
            return blockState;
        }
        ServerLevel sl = (ServerLevel)level;
        return (BlockState)blockState.m_61124_((Property)f_54117_, (Comparable)ctx.m_8125_().m_122424_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> p_51385_) {
        p_51385_.m_61104_(new Property[]{BAKE_STATE, f_54117_});
    }

    public void m_214162_(BlockState bs, Level level, BlockPos pos, RandomSource random) {
        if ((Integer)bs.m_61143_((Property)BAKE_STATE) == 3) {
            double d0 = (double)pos.m_123341_() + 0.5;
            double d1 = pos.m_123342_();
            double d2 = (double)pos.m_123343_() + 0.5;
            if (random.m_188500_() < 0.1) {
                level.m_6263_(null, d0, d1, d2, SoundEvents.f_11907_, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            Direction direction = (Direction)bs.m_61143_((Property)f_54117_);
            Direction.Axis direction$axis = direction.m_122434_();
            double d3 = 0.52;
            double d4 = random.m_188500_() * 0.6 - 0.3;
            double d5 = direction$axis == Direction.Axis.X ? (double)direction.m_122429_() * 0.52 : d4;
            double d6 = random.m_188500_() * 6.0 / 16.0;
            double d7 = direction$axis == Direction.Axis.Z ? (double)direction.m_122431_() * 0.52 : d4;
            level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, d0 + d5, d1 + d6, d2 + d7, 0.0, 0.0, 0.0);
            level.m_7106_((ParticleOptions)ParticleTypes.f_123744_, d0 + d5, d1 + d6, d2 + d7, 0.0, 0.0, 0.0);
        }
    }

    public InteractionResult m_6227_(BlockState blockState, Level level, BlockPos pos, Player player, InteractionHand p_60507_, BlockHitResult p_60508_) {
        if (!(level instanceof ServerLevel)) {
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        ServerLevel sl = (ServerLevel)level;
        if (BreadOvenBlock.hasBread(blockState)) {
            BreadOvenBlock.moveBreadToWorld(sl, pos, is -> player.m_150109_().m_36054_(is.toItem().toMCItemStack()));
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        if (BreadOvenBlock.canAcceptWheat(blockState)) {
            Compat.sendMessage((ServerPlayer)player, Compat.translatable("message.baker.villagers_will_add_wheat"));
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        if (BreadOvenBlock.canAcceptCoal(blockState)) {
            Compat.sendMessage((ServerPlayer)player, Compat.translatable("message.baker.villagers_will_add_coal"));
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    @Override
    public void setProcessingState(ServerLevel sl, BlockPos pp, State bs) {
        BlockState state = sl.m_8055_(pp);
        switch (bs.processingState()) {
            case 0: {
                if (bs.ingredientCount() <= 0) {
                    state = (BlockState)state.m_61124_((Property)BAKE_STATE, (Comparable)Integer.valueOf(0));
                    break;
                }
                if (bs.ingredientCount() < 2) {
                    state = (BlockState)state.m_61124_((Property)BAKE_STATE, (Comparable)Integer.valueOf(1));
                    break;
                }
                state = (BlockState)state.m_61124_((Property)BAKE_STATE, (Comparable)Integer.valueOf(2));
                break;
            }
            case 1: {
                if (bs.ingredientCount() < 1) {
                    state = (BlockState)state.m_61124_((Property)BAKE_STATE, (Comparable)Integer.valueOf(2));
                    break;
                }
                state = (BlockState)state.m_61124_((Property)BAKE_STATE, (Comparable)Integer.valueOf(3));
                break;
            }
            case 2: {
                state = (BlockState)state.m_61124_((Property)BAKE_STATE, (Comparable)Integer.valueOf(3));
                break;
            }
            case 3: {
                state = (BlockState)state.m_61124_((Property)BAKE_STATE, (Comparable)Integer.valueOf(4));
            }
        }
        sl.m_46597_(pp, state);
    }
}

