/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.blocks;

import ca.bradj.questown.blocks.InsertedItemAware;
import ca.bradj.questown.blocks.entity.FoodDisplayEntity;
import ca.bradj.questown.core.init.TagsInit;
import ca.bradj.questown.core.init.items.ItemsInit;
import ca.bradj.questown.integration.minecraft.MCHeldItem;
import ca.bradj.questown.jobs.declarative.MCExtra;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class FoodDisplayBlock
extends HorizontalDirectionalBlock
implements InsertedItemAware,
EntityBlock {
    public static final String ITEM_ID = "food_display";

    public FoodDisplayBlock() {
        super(BlockBehaviour.Properties.m_60944_((Material)Material.f_76320_, (MaterialColor)MaterialColor.f_76411_).m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_).m_60955_());
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        return (BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)ctx.m_8125_().m_122424_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> p_51385_) {
        p_51385_.m_61104_(new Property[]{f_54117_});
    }

    public void m_6810_(BlockState p_51538_, Level p_51539_, BlockPos pos, BlockState p_51541_, boolean p_51542_) {
        if (!p_51538_.m_60713_(p_51541_.m_60734_())) {
            BlockEntity blockentity = p_51539_.m_7702_(pos);
            if (blockentity instanceof FoodDisplayEntity) {
                FoodDisplayEntity fde = (FoodDisplayEntity)blockentity;
                if (p_51539_ instanceof ServerLevel) {
                    ServerLevel sl = (ServerLevel)p_51539_;
                    FoodDisplayBlock.dropAllLoot(pos, fde, sl);
                }
                p_51539_.m_46717_(pos, (Block)this);
            }
            super.m_6810_(p_51538_, p_51539_, pos, p_51541_, p_51542_);
        }
    }

    private static void dropAllLoot(BlockPos pos, FoodDisplayEntity fde, ServerLevel sl) {
        for (ItemStack item : fde.getItems()) {
            sl.m_7967_((Entity)new ItemEntity((Level)sl, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), item));
        }
        ItemStack item = ((Item)ItemsInit.FOOD_DISPLAY_BLOCK.get()).m_7968_();
        sl.m_7967_((Entity)new ItemEntity((Level)sl, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), item));
    }

    @Override
    public void handleInsertedItem(MCExtra extra, BlockPos bp, MCHeldItem item) {
        ServerLevel sl = extra.town().getServerLevel();
        BlockState bs = sl.m_8055_(bp);
        sl.m_46597_(bp, bs);
    }

    public InteractionResult m_6227_(BlockState p_60503_, Level p_60504_, BlockPos pos, Player p_60506_, InteractionHand p_60507_, BlockHitResult p_60508_) {
        if (!(p_60504_ instanceof ServerLevel)) {
            return InteractionResult.PASS;
        }
        ServerLevel sl = (ServerLevel)p_60504_;
        if (!InteractionHand.MAIN_HAND.equals((Object)p_60507_)) {
            return InteractionResult.PASS;
        }
        ItemStack item = p_60506_.m_21120_(p_60507_);
        BlockEntity blockentity = sl.m_7702_(pos);
        if (!(blockentity instanceof FoodDisplayEntity)) {
            return InteractionResult.PASS;
        }
        FoodDisplayEntity fde = (FoodDisplayEntity)blockentity;
        if (item.m_41619_()) {
            ItemStack removed = fde.removeFood();
            p_60506_.m_36356_(removed);
            return InteractionResult.CONSUME;
        }
        if (!Ingredient.m_204132_(TagsInit.Items.VILLAGER_FOOD).test(item)) {
            return InteractionResult.PASS;
        }
        if (fde.addFood(new ItemStack((ItemLike)item.m_41720_(), 1))) {
            item.m_41774_(1);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new FoodDisplayEntity(blockPos, blockState);
    }

    public RenderShape m_7514_(BlockState blockState) {
        return RenderShape.MODEL;
    }
}

