/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.blocks;

import ca.bradj.questown.Questown;
import ca.bradj.questown.blocks.Roomable;
import ca.bradj.questown.blocks.TownFlagBlock;
import ca.bradj.questown.blocks.TownFlagSubBlock;
import ca.bradj.questown.blocks.entity.BlockAsRoomEntity;
import ca.bradj.questown.core.init.TilesInit;
import ca.bradj.questown.logic.RoomRecipes;
import ca.bradj.questown.town.TownFlagBlockEntity;
import ca.bradj.roomrecipes.recipes.RoomRecipe;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RoomBlock
extends TownFlagSubBlock<BlockAsRoomEntity>
implements EntityBlock,
Roomable {
    public RoomBlock(BlockBehaviour.Properties p_49795_) {
        super(p_49795_, (bp, bs) -> (BlockAsRoomEntity)((BlockEntityType)TilesInit.BLOCK_AS_ROOM.get()).m_155264_(bp, bs), BlockAsRoomEntity::tick);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        BlockState stateForPlacement = super.m_5573_(ctx);
        Level level = ctx.m_43725_();
        if (!(level instanceof ServerLevel)) {
            return stateForPlacement;
        }
        ServerLevel sl = (ServerLevel)level;
        ItemStack item = ctx.m_43722_();
        @Nullable TownFlagBlockEntity parent = TownFlagBlock.GetParentFromNBT(sl, item);
        if (parent == null) {
            return stateForPlacement;
        }
        parent.getRoomHandle().registerBlockAsRoom(RoomBlock.getRoomId(this), ctx.m_8083_());
        return stateForPlacement;
    }

    @NotNull
    public static ResourceLocation getRoomId(RoomBlock rb) {
        return Questown.ResourceLocation("block_room/" + rb.m_7705_());
    }

    @Override
    protected BlockEntityType<BlockAsRoomEntity> getTickerEntityType() {
        return (BlockEntityType)TilesInit.BLOCK_AS_ROOM.get();
    }

    public RoomRecipe asRecipe() {
        Ingredient ing = Ingredient.m_43929_((ItemLike[])new ItemLike[]{this.m_5456_()});
        return RoomRecipes.standard(RoomBlock.getRoomId(this), (NonNullList<Ingredient>)NonNullList.m_122780_((int)1, (Object)ing));
    }
}

