/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.blocks;

import ca.bradj.questown.QT;
import ca.bradj.questown.blocks.InsertedItemAware;
import ca.bradj.questown.blocks.entity.SeedBinBlockEntity;
import ca.bradj.questown.core.init.items.ItemsInit;
import ca.bradj.questown.integration.minecraft.MCHeldItem;
import ca.bradj.questown.jobs.declarative.MCExtra;
import ca.bradj.questown.mc.Compat;
import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class SeedBinBlock
extends Block
implements InsertedItemAware,
EntityBlock {
    public static final String ITEM_ID = "seed_bin";
    public static final int MAX = 48;
    private static final IntegerProperty LEVEL = IntegerProperty.m_61631_((String)"level", (int)0, (int)48);

    public SeedBinBlock() {
        super(BlockBehaviour.Properties.m_60944_((Material)Material.f_76320_, (MaterialColor)MaterialColor.f_76411_).m_60913_(1.0f, 10.0f).m_60955_());
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)LEVEL, (Comparable)Integer.valueOf(0)));
    }

    public static int getLevel(BlockState blockState) {
        if (!blockState.m_61138_((Property)LEVEL)) {
            return 0;
        }
        return (Integer)blockState.m_61143_((Property)LEVEL);
    }

    public static BlockState reduceLevel(BlockState bs) {
        int l = SeedBinBlock.getLevel(bs);
        if (l == 0) {
            throw new IllegalStateException("Cannot reduce level below zero");
        }
        return (BlockState)bs.m_61124_((Property)LEVEL, (Comparable)Integer.valueOf(l - 1));
    }

    public static boolean isFull(BlockState blockState) {
        return SeedBinBlock.getLevel(blockState) == 48;
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        return (BlockState)this.m_49966_().m_61124_((Property)LEVEL, (Comparable)Integer.valueOf(0));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> p_51385_) {
        p_51385_.m_61104_(new Property[]{LEVEL});
    }

    public List<ItemStack> m_7381_(BlockState p_60537_, LootContext.Builder p_60538_) {
        ImmutableList.Builder b = ImmutableList.builder();
        b.add((Object)((Item)ItemsInit.SEED_BIN_BLOCK.get()).m_7968_());
        int level = SeedBinBlock.getLevel(p_60537_);
        for (int i = 0; i < level; ++i) {
            b.add((Object)Items.f_42404_.m_7968_());
        }
        return b.build();
    }

    @Override
    public void handleInsertedItem(MCExtra extra, BlockPos bp, MCHeldItem item) {
        ServerLevel sl = extra.town().getServerLevel();
        int curLevel = 0;
        BlockState bs = sl.m_8055_(bp);
        if (bs.m_61138_((Property)LEVEL)) {
            curLevel = (Integer)bs.m_61143_((Property)LEVEL);
        }
        bs = (BlockState)bs.m_61124_((Property)LEVEL, (Comparable)Integer.valueOf(Math.min(48, curLevel + 1)));
        sl.m_46597_(bp, bs);
    }

    public InteractionResult m_6227_(BlockState p_60503_, Level p_60504_, BlockPos p_60505_, Player p_60506_, InteractionHand p_60507_, BlockHitResult p_60508_) {
        InteractionResult r = super.m_6227_(p_60503_, p_60504_, p_60505_, p_60506_, p_60507_, p_60508_);
        if (p_60504_.m_5776_()) {
            return InteractionResult.CONSUME;
        }
        SeedBinBlock.addSeed(p_60504_, p_60505_, p_60503_);
        return InteractionResult.CONSUME;
    }

    public static boolean addSeed(Level p_60504_, BlockPos p_60505_, BlockState p) {
        boolean b;
        int oldVal = (Integer)p.m_61143_((Property)LEVEL);
        int newVal = (oldVal + 1) % 49;
        p = (BlockState)p.m_61124_((Property)LEVEL, (Comparable)Integer.valueOf(newVal));
        p_60504_.m_46597_(p_60505_, p);
        QT.BLOCK_LOGGER.debug("New level {}", (Object)newVal);
        boolean bl = b = oldVal != newVal;
        if (b && p_60504_ instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)p_60504_;
            Compat.playSound(sl, p_60505_, SoundEvents.f_11765_, SoundSource.BLOCKS);
        }
        return b;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new SeedBinBlockEntity(blockPos, blockState);
    }
}

