/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.blocks;

import ca.bradj.questown.QT;
import ca.bradj.questown.blocks.InsertedItemAware;
import ca.bradj.questown.blocks.StatefulJobBlock;
import ca.bradj.questown.core.init.items.ItemsInit;
import ca.bradj.questown.integration.minecraft.MCHeldItem;
import ca.bradj.questown.jobs.declarative.MCExtra;
import ca.bradj.questown.mc.Compat;
import ca.bradj.questown.mc.Util;
import ca.bradj.questown.town.workstatus.State;
import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SmallSoupPotBlock
extends Block
implements InsertedItemAware,
StatefulJobBlock {
    public static final String ITEM_ID = "soup_pot_small";
    protected static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0);
    private static final IntegerProperty LEVEL = IntegerProperty.m_61631_((String)"level", (int)0, (int)1);

    public SmallSoupPotBlock() {
        super(BlockBehaviour.Properties.m_60944_((Material)Material.f_76275_, (MaterialColor)MaterialColor.f_76384_).m_60913_(1.0f, 10.0f).m_60955_());
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)LEVEL, (Comparable)Integer.valueOf(0)));
    }

    public VoxelShape m_5940_(BlockState p_60555_, BlockGetter p_60556_, BlockPos p_60557_, CollisionContext p_60558_) {
        return SHAPE;
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        return (BlockState)this.m_49966_().m_61124_((Property)LEVEL, (Comparable)Integer.valueOf(0));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> p_51385_) {
        p_51385_.m_61104_(new Property[]{LEVEL});
    }

    public List<ItemStack> m_7381_(BlockState p_60537_, LootContext.Builder p_60538_) {
        return ImmutableList.of((Object)((Item)ItemsInit.SMALL_SOUP_POT_BLOCK.get()).m_7968_());
    }

    @Override
    public void handleInsertedItem(MCExtra extra, BlockPos bp, MCHeldItem item) {
    }

    public InteractionResult m_6227_(BlockState p_60503_, Level level, BlockPos blockPos, Player player, InteractionHand hand, BlockHitResult p_60508_) {
        if (level.m_5776_()) {
            return InteractionResult.CONSUME;
        }
        return SmallSoupPotBlock.tryTakeSoup(level, blockPos, LEVEL, 1, player, hand);
    }

    public static InteractionResult tryTakeSoup(Level level, BlockPos p_60505_, IntegerProperty prop, int takeAmount, Player player, InteractionHand hand) {
        BlockState p = level.m_8055_(p_60505_);
        ItemStack itemInHand = player.m_21120_(hand);
        if (itemInHand.m_41720_() instanceof BlockItem) {
            return InteractionResult.PASS;
        }
        int oldVal = (Integer)p.m_61143_((Property)prop);
        if (oldVal < takeAmount) {
            Compat.sendMessage((ServerPlayer)player, Compat.translatable("message.questown.soup_pot.empty"));
            return InteractionResult.CONSUME;
        }
        if (!itemInHand.m_150930_(Items.f_42399_)) {
            Compat.sendMessage((ServerPlayer)player, Compat.translatable("message.questown.soup_pot.need_bowl"));
            return InteractionResult.CONSUME;
        }
        int levelValue = Math.max((Integer)p.m_61143_((Property)prop) - takeAmount, 0);
        p = (BlockState)p.m_61124_((Property)prop, (Comparable)Integer.valueOf(levelValue));
        level.m_46597_(p_60505_, p);
        QT.BLOCK_LOGGER.debug("New level {}", (Object)levelValue);
        player.m_21008_(hand, Items.f_42400_.m_7968_());
        return InteractionResult.CONSUME;
    }

    @Override
    public void setProcessingState(ServerLevel sl, BlockPos pp, State bs) {
        Util.setProcessingStateOnProperty(sl, LEVEL, bs, pp);
    }
}

