/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.blocks;

import ca.bradj.questown.blocks.ExtractedItemAware;
import ca.bradj.questown.blocks.InsertedItemAware;
import ca.bradj.questown.blocks.SmallSoupPotBlock;
import ca.bradj.questown.core.init.items.ItemsInit;
import ca.bradj.questown.integration.minecraft.MCHeldItem;
import ca.bradj.questown.jobs.declarative.MCExtra;
import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.phys.BlockHitResult;

public class SoupPotBlock
extends Block
implements InsertedItemAware,
ExtractedItemAware {
    public static final String ITEM_ID = "soup_pot";
    public static final int MAX = 12;
    private static final IntegerProperty LEVEL = IntegerProperty.m_61631_((String)"level", (int)0, (int)12);

    public SoupPotBlock() {
        super(BlockBehaviour.Properties.m_60944_((Material)Material.f_76275_, (MaterialColor)MaterialColor.f_76384_).m_60913_(1.0f, 10.0f).m_60955_());
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)LEVEL, (Comparable)Integer.valueOf(0)));
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        return (BlockState)this.m_49966_().m_61124_((Property)LEVEL, (Comparable)Integer.valueOf(0));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> p_51385_) {
        p_51385_.m_61104_(new Property[]{LEVEL});
    }

    public List<ItemStack> m_7381_(BlockState p_60537_, LootContext.Builder p_60538_) {
        return ImmutableList.of((Object)((Item)ItemsInit.SOUP_POT_BLOCK.get()).m_7968_());
    }

    @Override
    public void handleInsertedItem(MCExtra extra, BlockPos bp, MCHeldItem item) {
        ServerLevel sl = extra.town().getServerLevel();
        int curLevel = 0;
        BlockState bs = sl.m_8055_(bp);
        if (bs.m_61138_((Property)LEVEL)) {
            curLevel = (Integer)bs.m_61143_((Property)LEVEL);
        }
        bs = (BlockState)bs.m_61124_((Property)LEVEL, (Comparable)Integer.valueOf(Math.min(12, curLevel + 1)));
        sl.m_46597_(bp, bs);
    }

    @Override
    public void handleExtractedItem(MCExtra extra, BlockPos bp) {
        ServerLevel sl = extra.town().getServerLevel();
        int curLevel = 0;
        BlockState bs = sl.m_8055_(bp);
        if (bs.m_61138_((Property)LEVEL)) {
            curLevel = (Integer)bs.m_61143_((Property)LEVEL);
        }
        bs = (BlockState)bs.m_61124_((Property)LEVEL, (Comparable)Integer.valueOf(Math.max(0, curLevel - 1)));
        sl.m_46597_(bp, bs);
    }

    public InteractionResult m_6227_(BlockState p_60503_, Level p_60504_, BlockPos p_60505_, Player p_60506_, InteractionHand p_60507_, BlockHitResult p_60508_) {
        if (p_60504_.m_5776_()) {
            return InteractionResult.CONSUME;
        }
        return SmallSoupPotBlock.tryTakeSoup(p_60504_, p_60505_, LEVEL, 2, p_60506_, p_60507_);
    }
}

