/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.commands;

import ca.bradj.questown.jobs.JobID;
import com.google.common.collect.ImmutableList;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import org.jetbrains.annotations.NotNull;

public class JobArgument
implements ArgumentType<JobID> {
    public static Collection<JobID> jobIDs = ImmutableList.of();

    public JobArgument(CommandBuildContext ctx) {
    }

    @NotNull
    public static ArgumentType<JobID> job(CommandBuildContext ctx) {
        return new JobArgument(ctx);
    }

    public static JobID getJob(CommandContext<CommandSourceStack> ctx, String name) {
        return (JobID)ctx.getArgument(name, JobID.class);
    }

    public JobID parse(StringReader reader) throws CommandSyntaxException {
        String rootId = reader.readString();
        reader.read();
        String workId = reader.readString();
        return new JobID(rootId, workId);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        jobIDs.forEach(v -> builder.suggest(String.format("%s:%s", v.rootId(), v.jobId())));
        return builder.buildFuture();
    }
}

