/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.core;

import ca.bradj.questown.core.network.QuestownNetwork;
import ca.bradj.questown.core.network.SyncWorkForCommandsMessage;
import ca.bradj.questown.jobs.JobID;
import ca.bradj.questown.jobs.ResourceJobLoader;
import ca.bradj.questown.jobs.ServerJobsRegistry;
import ca.bradj.questown.jobs.Work;
import ca.bradj.questown.jobs.Works;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(modid="questown", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class JobFileEvents {
    @SubscribeEvent
    public static void reloadListeners(ServerAboutToStartEvent event) {
        ResourceJobLoader.LISTENER.loadFromFiles(event.getServer().m_177941_());
        ImmutableMap<JobID, Work> jobs = ResourceJobLoader.LISTENER.getJobs();
        Works.staticInitialize(jobs);
        ServerJobsRegistry.staticInitialize(jobs);
    }

    @SubscribeEvent
    public static void playerJoined(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer sp = (ServerPlayer)player;
        ImmutableList ids = ImmutableList.copyOf(Works.ids());
        SyncWorkForCommandsMessage ms = new SyncWorkForCommandsMessage((ImmutableList<JobID>)ids);
        QuestownNetwork.CHANNEL.send(PacketDistributor.PLAYER.with(() -> sp), (Object)ms);
    }
}

