/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.core;

import ca.bradj.questown.Questown;
import ca.bradj.questown.core.CommonRecipes;
import ca.bradj.questown.core.CraftedResource;
import ca.bradj.questown.core.CraftedResources;
import ca.bradj.questown.core.FarmedResource;
import ca.bradj.questown.core.MinedResource;
import ca.bradj.questown.core.MinedResources;
import ca.bradj.questown.core.Rarity;
import ca.bradj.questown.core.RecipeItemScore;
import ca.bradj.questown.core.Resource;
import ca.bradj.questown.core.init.TagsInit;
import ca.bradj.questown.core.init.items.ItemsInit;
import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.ConfigFormat;
import com.electronwill.nightconfig.core.InMemoryFormat;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class RecipeItemConfig {
    public static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec SPEC;
    public static final String ITEM_WEIGHTS = "Item weights";
    private static final Config defaultItemWeights;
    public static final ForgeConfigSpec.ConfigValue<Config> itemWeights;
    private static final int TORCH_SCORE;
    private static final int STICK_SCORE;
    private static final int CRAFTING_TABLE;
    private static final int BED;
    private static final int DIRT;
    private static final int CHEST;
    private static final int FURNACE;
    private static final int SIGN;
    private static final int BOOKSHELF;
    private static final int ENCH_TABLE;
    private static final int BREW_STAND;
    private static final int LANTERN;
    private static final int TARGET;
    private static final int CAULDRON;
    private static final int HOSPITAL_BED;
    public static final int SMALL_SOUP_POT;
    public static final int BIG_SOUP_POT;
    public static final int COMPOSTER;
    public static final int ORE_PROCESSING_BLOCK;
    public static final int BREAD_OVEN_BLOCK;
    public static final int FOOD_DISPLAY;
    public static final String FILENAME = "questown-item-weights-server.toml";

    @NotNull
    private static ResourceLocation assumePresent(Item item) {
        return ForgeRegistries.ITEMS.getKey((Object)item);
    }

    private static void add(ResourceLocation itemOrTagKey, int cost) {
        defaultItemWeights.add(itemOrTagKey.toString(), (Object)cost);
    }

    private static void add(String itemOrTagKey, int cost) {
        defaultItemWeights.add(itemOrTagKey, (Object)cost);
    }

    static {
        defaultItemWeights = Config.of((ConfigFormat)InMemoryFormat.defaultInstance());
        TORCH_SCORE = RecipeItemScore.canCraftInFourGrid(CommonRecipes.TORCH_INGREDIENTS, false);
        STICK_SCORE = RecipeItemScore.canCraftInFourGrid(CommonRecipes.STICK_INGREDIENTS, false);
        CRAFTING_TABLE = RecipeItemScore.canCraftInFourGrid(CommonRecipes.CRAFTING_TABLE, false);
        BED = RecipeItemScore.requiresCraftingTable((Collection<? extends Resource>)ImmutableList.of((Object)new MinedResource("wool", Rarity.SOMETIMES_HARD_TO_FIND), (Object)new MinedResource("wool", Rarity.SOMETIMES_HARD_TO_FIND), (Object)new MinedResource("wool", Rarity.SOMETIMES_HARD_TO_FIND), (Object)new CraftedResource("planks", 4, (Collection<? extends Resource>)ImmutableList.of((Object)new MinedResource("wood", Rarity.EASY_TO_FIND))), (Object)new CraftedResource("planks", 4, (Collection<? extends Resource>)ImmutableList.of((Object)new MinedResource("wood", Rarity.EASY_TO_FIND))), (Object)new CraftedResource("planks", 4, (Collection<? extends Resource>)ImmutableList.of((Object)new MinedResource("wood", Rarity.EASY_TO_FIND)))), true);
        DIRT = new MinedResource("dirt", Rarity.ITS_EVERYWHERE).calculateValue();
        CHEST = RecipeItemScore.requiresCraftingTable(CommonRecipes.CHEST, true);
        FURNACE = RecipeItemScore.requiresCraftingTable(Collections.nCopies(8, new MinedResource("cobblestone", Rarity.ITS_EVERYWHERE)), false);
        SIGN = RecipeItemScore.requiresCraftingTable(CommonRecipes.SIGN, false);
        BOOKSHELF = RecipeItemScore.requiresCraftingTable(CommonRecipes.BOOKSHELF, false);
        ENCH_TABLE = RecipeItemScore.requiresCraftingTable(CommonRecipes.ENCH_TABLE, false);
        BREW_STAND = RecipeItemScore.requiresCraftingTable(CommonRecipes.BREW_STAND, false);
        LANTERN = RecipeItemScore.requiresCraftingTable(CommonRecipes.LANTERN, false);
        TARGET = RecipeItemScore.requiresCraftingTable((Collection<? extends Resource>)ImmutableList.of((Object)new MinedResource("redstone_dust", Rarity.SOMETIMES_HARD_TO_FIND), (Object)new MinedResource("redstone_dust", Rarity.SOMETIMES_HARD_TO_FIND), (Object)new MinedResource("redstone_dust", Rarity.SOMETIMES_HARD_TO_FIND), (Object)new MinedResource("redstone_dust", Rarity.SOMETIMES_HARD_TO_FIND), (Object)new CraftedResource("hay_bale", 1, Collections.nCopies(9, new FarmedResource("wheat", Rarity.ITS_EVERYWHERE)))), false);
        CAULDRON = RecipeItemScore.requiresCraftingTable((Collection<? extends Resource>)ImmutableList.copyOf(Collections.nCopies(7, CraftedResources.IRON_ORE_OR_INGOT)), false);
        HOSPITAL_BED = STICK_SCORE + BED;
        SMALL_SOUP_POT = RecipeItemScore.canCraftInFourGrid((Collection<? extends Resource>)ImmutableList.of((Object)CraftedResources.FLOWER_POT, (Object)CraftedResources.CAMPFIRE), false);
        BIG_SOUP_POT = RecipeItemScore.requiresCraftingTable((Collection<? extends Resource>)ImmutableList.of((Object)CraftedResources.CLAY_BRICK, (Object)CraftedResources.CLAY_BRICK, (Object)CraftedResources.CLAY_BRICK, (Object)CraftedResources.CLAY_BRICK, (Object)CraftedResources.SMALL_SOUP_POT, (Object)CraftedResources.CLAY_BRICK, (Object)CraftedResources.CLAY_BRICK, (Object)CraftedResources.CLAY_BRICK, (Object)CraftedResources.CLAY_BRICK), false);
        COMPOSTER = RecipeItemScore.requiresCraftingTable((Collection<? extends Resource>)ImmutableList.of((Object)CraftedResources.WOOD_SLAB, (Object)CraftedResources.WOOD_SLAB, (Object)CraftedResources.WOOD_SLAB, (Object)CraftedResources.WOOD_SLAB, (Object)CraftedResources.WOOD_SLAB, (Object)CraftedResources.WOOD_SLAB, (Object)CraftedResources.WOOD_SLAB), false);
        ORE_PROCESSING_BLOCK = RecipeItemScore.canCraftInFourGrid((Collection<? extends Resource>)ImmutableList.of((Object)CraftedResources.PLANKS, (Object)CraftedResources.PLANKS, (Object)CraftedResources.STONE_PICKAXE, (Object)CraftedResources.CRAFTING_TABLE), false);
        BREAD_OVEN_BLOCK = RecipeItemScore.canCraftInFourGrid((Collection<? extends Resource>)ImmutableList.of((Object)MinedResources.COBBLESTONE, (Object)MinedResources.COBBLESTONE, (Object)CraftedResources.CRAFTING_TABLE, (Object)CraftedResources.FURNACE), false);
        FOOD_DISPLAY = RecipeItemScore.requiresCraftingTable((Collection<? extends Resource>)ImmutableList.of((Object)CraftedResources.PLANKS, (Object)CraftedResources.PLANKS, (Object)CraftedResources.PLANKS, (Object)CraftedResources.PLANKS, (Object)CraftedResources.PLANKS, (Object)CraftedResources.PLANKS, (Object)CraftedResources.PLANKS, (Object)CraftedResources.PLANKS, (Object)CraftedResources.TOWN_WAND), false);
        RecipeItemConfig.add(RecipeItemConfig.assumePresent(Items.f_42329_), DIRT);
        RecipeItemConfig.add(String.format("#%s", ItemTags.f_13146_.f_203868_()), BED);
        RecipeItemConfig.add(String.format("#%s", ItemTags.f_198160_.f_203868_()), DIRT);
        RecipeItemConfig.add(String.format("#%s", TagsInit.Items.LIGHT_SOURCES.f_203868_()), TORCH_SCORE);
        RecipeItemConfig.add(RecipeItemConfig.assumePresent(Items.f_42000_), TORCH_SCORE);
        RecipeItemConfig.add(RecipeItemConfig.assumePresent(Items.f_41960_), CRAFTING_TABLE);
        RecipeItemConfig.add(RecipeItemConfig.assumePresent(Items.f_42778_), LANTERN);
        RecipeItemConfig.add(String.format("#%s", TagsInit.Items.LANTERNS.f_203868_()), LANTERN);
        RecipeItemConfig.add(RecipeItemConfig.assumePresent(Items.f_42009_), CHEST);
        RecipeItemConfig.add(String.format("#%s", Tags.Items.CHESTS.f_203868_()), CHEST);
        RecipeItemConfig.add(RecipeItemConfig.assumePresent(Items.f_41962_), FURNACE);
        RecipeItemConfig.add(String.format("#%s", ItemTags.f_13157_.f_203868_()), SIGN);
        RecipeItemConfig.add(RecipeItemConfig.assumePresent(Items.f_41997_), BOOKSHELF);
        RecipeItemConfig.add(RecipeItemConfig.assumePresent(Items.f_42100_), ENCH_TABLE);
        RecipeItemConfig.add(RecipeItemConfig.assumePresent(Items.f_42543_), BREW_STAND);
        RecipeItemConfig.add(RecipeItemConfig.assumePresent(Items.f_42793_), TARGET);
        RecipeItemConfig.add(RecipeItemConfig.assumePresent(Items.f_42544_), CAULDRON);
        RecipeItemConfig.add(Questown.ResourceLocation("soup_pot_small"), SMALL_SOUP_POT);
        RecipeItemConfig.add("soup_pot", BIG_SOUP_POT);
        RecipeItemConfig.add(RecipeItemConfig.assumePresent(Items.f_42726_), COMPOSTER);
        RecipeItemConfig.add(ItemsInit.PLATE_BLOCK.getId(), Integer.MAX_VALUE);
        RecipeItemConfig.add(String.format("#%s", TagsInit.Items.SOUP_POTS.f_203868_()), SMALL_SOUP_POT);
        RecipeItemConfig.add(ItemsInit.BOWL_RACK_BLOCK.getId(), Integer.MAX_VALUE);
        RecipeItemConfig.add(ItemsInit.ORE_PROCESSING_BLOCK.getId(), ORE_PROCESSING_BLOCK);
        RecipeItemConfig.add(ItemsInit.BREAD_OVEN_BLOCK.getId(), BREAD_OVEN_BLOCK);
        RecipeItemConfig.add(ItemsInit.FOOD_DISPLAY_BLOCK.getId(), FOOD_DISPLAY);
        RecipeItemConfig.add(String.format("#%s", TagsInit.Items.JOB_BOARD_INPUTS.f_203868_()), Integer.MAX_VALUE);
        BUILDER.push(FILENAME);
        itemWeights = BUILDER.define(ITEM_WEIGHTS, (Object)defaultItemWeights);
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

