/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.core;

import java.util.Objects;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import org.jetbrains.annotations.Nullable;

public final class VillagerUUID {
    private final UUID uuid;

    private VillagerUUID(UUID uuid) {
        this.uuid = uuid;
    }

    @Deprecated(forRemoval=true, since="0.0.9")
    @Nullable
    public static VillagerUUID from(@Nullable UUID randomVillager) {
        if (randomVillager == null) {
            return null;
        }
        return new VillagerUUID(randomVillager);
    }

    public static VillagerUUID fromNBT(CompoundTag nbt, String key) {
        return new VillagerUUID(nbt.m_128342_(key));
    }

    public static VillagerUUID random() {
        return new VillagerUUID(UUID.randomUUID());
    }

    @Deprecated(forRemoval=true, since="0.0.9")
    @Nullable
    public static UUID get(@Nullable VillagerUUID v) {
        if (v == null) {
            return null;
        }
        return v.uuid;
    }

    public static String getStringUUID(VillagerUUID villagerUUID) {
        if (villagerUUID == null) {
            return "";
        }
        return villagerUUID.uuid.toString();
    }

    public static VillagerUUID fromNetwork(FriendlyByteBuf buf) {
        String s = buf.m_130277_();
        if (s.isEmpty()) {
            return null;
        }
        return new VillagerUUID(UUID.fromString(s));
    }

    public static void toNetwork(FriendlyByteBuf buf, VillagerUUID villagerUUID) {
        String v = "";
        if (villagerUUID != null) {
            v = VillagerUUID.getStringUUID(villagerUUID);
        }
        buf.m_130070_(v);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        VillagerUUID that = (VillagerUUID)obj;
        return Objects.equals(this.uuid, that.uuid);
    }

    public int hashCode() {
        return Objects.hash(this.uuid);
    }

    public String toString() {
        return "VillagerUUID[" + String.valueOf(this.uuid) + "]";
    }

    public void writeToNBT(CompoundTag tag, String value) {
        tag.m_128362_(value, this.uuid);
    }

    public boolean matches(UUID owner) {
        return this.uuid.equals(owner);
    }
}

