/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.core.advancements;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.Predicate;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public class ApproachTownTrigger
extends SimpleCriterionTrigger<Instance> {
    public static final ResourceLocation ID = new ResourceLocation("questown", "approach_town");

    public ResourceLocation m_7295_() {
        return ID;
    }

    public Instance createInstance(JsonObject json, EntityPredicate.Composite predicate, DeserializationContext parser) {
        if (!json.has("context")) {
            throw new IllegalStateException(String.format("Trigger of type %s is missing context [ID: %s]", ID, parser.m_25873_()));
        }
        return new Instance(predicate, Triggers.fromJSON(json.get("context")));
    }

    protected void m_66234_(ServerPlayer p_235959_1_, Predicate<Instance> p_235959_2_) {
        super.m_66234_(p_235959_1_, p_235959_2_);
    }

    public void trigger(ServerPlayer player, Triggers trickID) {
        super.m_66234_(player, instance -> instance.matches(trickID));
    }

    public static class Instance
    extends AbstractCriterionTriggerInstance {
        private final Triggers trickID;

        public Instance(EntityPredicate.Composite p_i231464_2_, Triggers trickID) {
            super(ID, p_i231464_2_);
            if (Triggers.Invalid.equals((Object)trickID)) {
                throw new IllegalArgumentException("context must not be invalid");
            }
            this.trickID = trickID;
        }

        public boolean matches(Triggers trickID) {
            return this.trickID.equals((Object)trickID);
        }
    }

    public static enum Triggers {
        Invalid,
        FirstVisit;

        private static final BiMap<Triggers, String> stringVals;

        public static Triggers fromJSON(JsonElement trick_id) {
            String key = trick_id.getAsString();
            if (!stringVals.inverse().containsKey((Object)key)) {
                throw new IllegalArgumentException(String.format("Approach trigger ID is unexpected: %s", trick_id));
            }
            return (Triggers)((Object)stringVals.inverse().get((Object)key));
        }

        public String getID() {
            return (String)stringVals.get((Object)this);
        }

        static {
            stringVals = ImmutableBiMap.of((Object)((Object)FirstVisit), (Object)"first_visit");
        }
    }
}

