/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.core.init.items;

import ca.bradj.questown.Questown;
import ca.bradj.questown.blocks.RoomBlock;
import ca.bradj.questown.blocks.TownFlagBlock;
import ca.bradj.questown.core.init.BlocksInit;
import ca.bradj.questown.items.EffectMetaItem;
import ca.bradj.questown.items.FalseDoorItem;
import ca.bradj.questown.items.FalseWallItem;
import ca.bradj.questown.items.GathererMap;
import ca.bradj.questown.items.HospitalBedItem;
import ca.bradj.questown.items.KnowledgeMetaItem;
import ca.bradj.questown.items.StockRequestClipboardItem;
import ca.bradj.questown.items.StockRequestItem;
import ca.bradj.questown.items.TownDoorItem;
import ca.bradj.questown.items.TownDoorTestItem;
import ca.bradj.questown.items.TownFenceGateItem;
import ca.bradj.questown.items.TownWand;
import ca.bradj.questown.mc.Compat;
import ca.bradj.questown.mc.Util;
import ca.bradj.questown.town.TownFlagBlockEntity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(modid="questown", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ItemsInit {
    private static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"questown");
    public static final RegistryObject<Item> TOWN_FLAG_BLOCK = ITEMS.register("flag_base", () -> new BlockItem((Block)BlocksInit.COBBLESTONE_TOWN_FLAG.get(), TownFlagBlock.ITEM_PROPS));
    public static final RegistryObject<Item> WELCOME_MAT_BLOCK = ITEMS.register("welcome_mat_block", () -> new BlockItem((Block)BlocksInit.WELCOME_MAT_BLOCK.get(), Questown.DEFAULT_ITEM_PROPS));
    public static final RegistryObject<Item> FALSE_WALL_BLOCK = ITEMS.register("false_wall_block", FalseWallItem::new);
    public static final RegistryObject<Item> JOB_BOARD_BLOCK = ITEMS.register("job_board_block", () -> new BlockItem((Block)BlocksInit.JOB_BOARD_BLOCK.get(), Questown.DEFAULT_ITEM_PROPS));
    public static final RegistryObject<Item> BREAD_OVEN_BLOCK = ITEMS.register("bread_oven_block", () -> new BlockItem((Block)BlocksInit.BREAD_OVEN_BLOCK.get(), Questown.DEFAULT_ITEM_PROPS));
    public static final RegistryObject<Item> ORE_PROCESSING_BLOCK = ITEMS.register("ore_processing_block", () -> new BlockItem((Block)BlocksInit.ORE_PROCESSING_BLOCK.get(), Questown.DEFAULT_ITEM_PROPS));
    public static final RegistryObject<Item> BLACKSMITHS_TABLE_BLOCK = ITEMS.register("blacksmiths_table", () -> new BlockItem((Block)BlocksInit.BLACKSMITHS_TABLE_BLOCK.get(), Questown.DEFAULT_ITEM_PROPS));
    public static final RegistryObject<Item> PLATE_BLOCK = ITEMS.register("plate_block", () -> new BlockItem((Block)BlocksInit.PLATE_BLOCK.get(), Questown.DEFAULT_ITEM_PROPS));
    public static final RegistryObject<Item> SOUP_POT_BLOCK = ITEMS.register("soup_pot", () -> new BlockItem((Block)BlocksInit.SOUP_POT.get(), Questown.DEFAULT_ITEM_PROPS));
    public static final RegistryObject<Item> BOWL_RACK_BLOCK = ITEMS.register("bowl_rack", () -> new BlockItem((Block)BlocksInit.BOWL_RACK.get(), Questown.DEFAULT_ITEM_PROPS));
    public static final RegistryObject<Item> SEED_BIN_BLOCK = ITEMS.register("seed_bin", () -> new BlockItem((Block)BlocksInit.SEED_BIN.get(), Questown.DEFAULT_ITEM_PROPS));
    public static final RegistryObject<Item> AXE_RACK_BLOCK = ITEMS.register("axe_rack_block", () -> new BlockItem((Block)BlocksInit.AXE_RACK.get(), Questown.DEFAULT_ITEM_PROPS));
    public static final RegistryObject<Item> FOOD_DISPLAY_BLOCK = ITEMS.register("food_display", () -> new BlockItem((Block)BlocksInit.FOOD_DISPLAY.get(), Questown.DEFAULT_ITEM_PROPS));
    public static final RegistryObject<Item> SMALL_SOUP_POT_BLOCK = ITEMS.register("soup_pot_small", () -> new BlockItem((Block)BlocksInit.SOUP_POT_SMALL.get(), Questown.DEFAULT_ITEM_PROPS));
    public static final RegistryObject<Item> BLOCK_OF_PROGRESS = ITEMS.register("block_of_progress", () -> new BlockItem((Block)BlocksInit.BLOCK_OF_PROGRESS.get(), Questown.DEFAULT_ITEM_PROPS));
    public static final RegistryObject<Item> FISHING_STATION_BLOCK = ITEMS.register("fishing_station", () -> new BlockItem((Block)BlocksInit.FISHING_STATION_BLOCK.get(), Questown.DEFAULT_ITEM_PROPS));
    public static final RegistryObject<Item> MINESHAFT_BLOCK = ITEMS.register("mineshaft", () -> new BlockItem((Block)BlocksInit.MINESHAFT.get(), Questown.DEFAULT_ITEM_PROPS));
    public static final RegistryObject<Item> TOWN_DOOR = ITEMS.register("town_door", TownDoorItem::new);
    public static final RegistryObject<Item> TOWN_DOOR_TESTER = ITEMS.register("town_door_tester", TownDoorTestItem::new);
    public static final RegistryObject<Item> FALSE_DOOR = ITEMS.register("false_door_block", FalseDoorItem::new);
    public static final RegistryObject<Item> TOWN_FENCE_GATE = ITEMS.register("town_fence_gate", TownFenceGateItem::new);
    public static final RegistryObject<Item> GATHERER_MAP = ITEMS.register("gatherer_map", GathererMap::new);
    public static final RegistryObject<Item> TOWN_WAND = ITEMS.register("town_wand", TownWand::new);
    public static final RegistryObject<Item> STOCK_REQUEST = ITEMS.register("stock_request", StockRequestItem::new);
    public static final RegistryObject<Item> STOCK_REQUEST_CLIPBOARD = ITEMS.register("stock_request_clipboard", StockRequestClipboardItem::new);
    public static final RegistryObject<Item> KNOWLEDGE = ITEMS.register("knowledge_meta_item", KnowledgeMetaItem::new);
    public static final RegistryObject<Item> EFFECT = ITEMS.register("effect_meta_item", EffectMetaItem::new);
    public static final RegistryObject<Item> HOSPITAL_BED = ITEMS.register("hospital_bed", () -> new HospitalBedItem((Block)BlocksInit.HOSPITAL_BED.get(), Questown.DEFAULT_ITEM_PROPS.m_41487_(1)));
    public static final RegistryObject<Item> SAPLING_TESTER_BLOCK = ITEMS.register("sapling_tester", () -> new BlockItem((Block)BlocksInit.SAPLING_TESTER_BLOCK.get(), Questown.DEFAULT_ITEM_PROPS));

    @SubscribeEvent
    public static void onInteractBlock(PlayerInteractEvent.RightClickBlock event) {
        ServerLevel sl;
        TownFlagBlockEntity parent;
        BlockItem bi;
        Level level = event.getLevel();
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer sp = (ServerPlayer)player;
        if (level.m_7702_(event.getPos()) instanceof TownFlagBlockEntity) {
            return;
        }
        Item itemUsed = event.getItemStack().m_41720_();
        if (itemUsed instanceof TownWand) {
            TownWand item = (TownWand)itemUsed;
            item.onRightClicked(() -> (ServerPlayer)event.getEntity(), (ServerLevel)event.getLevel(), event.getPos(), event.getItemStack());
        }
        if (itemUsed instanceof BlockItem && (bi = (BlockItem)itemUsed).m_40614_() instanceof RoomBlock && (parent = TownFlagBlock.GetParentFromNBT(sl = (ServerLevel)event.getLevel(), event.getItemStack())) == null) {
            Util.onScreenText(() -> sp, "message.questown.room_block.how_to_flag", Compat.getItemName((Item)TOWN_WAND.get()));
        }
    }

    public static void register(IEventBus bus) {
        ITEMS.register(bus);
    }
}

