/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.core.network;

import ca.bradj.questown.core.init.items.ItemsInit;
import ca.bradj.questown.core.network.CloseScreensMessage;
import ca.bradj.questown.core.network.QuestownNetwork;
import ca.bradj.questown.items.StockRequestItem;
import ca.bradj.questown.jobs.requests.WorkRequest;
import ca.bradj.questown.mc.Compat;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public record CreateStockRequestFromUIMessage(WorkRequest item, int flagX, int flagY, int flagZ, UUID playerUUID) {
    public static void encode(CreateStockRequestFromUIMessage msg, FriendlyByteBuf buffer) {
        msg.item.toNetwork(buffer);
        buffer.writeInt(msg.flagX());
        buffer.writeInt(msg.flagY());
        buffer.writeInt(msg.flagZ());
        buffer.m_130077_(msg.playerUUID());
    }

    public static CreateStockRequestFromUIMessage decode(FriendlyByteBuf buffer) {
        WorkRequest ing = WorkRequest.fromNetwork(buffer);
        int flagX = buffer.readInt();
        int flagY = buffer.readInt();
        int flagZ = buffer.readInt();
        UUID id = buffer.m_130259_();
        return new CreateStockRequestFromUIMessage(ing, flagX, flagY, flagZ, id);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer sender = ((NetworkEvent.Context)ctx.get()).getSender();
            if (sender.m_150109_().m_36062_() == 0) {
                Compat.sendMessage(sender, Compat.translatable("no_room_for_request"));
                return;
            }
            ItemStack toGive = ((Item)ItemsInit.STOCK_REQUEST.get()).m_7968_();
            StockRequestItem.writeToNBT(toGive.m_41784_(), this.item);
            ItemStack given = new ItemStack((ItemLike)toGive.m_41720_(), toGive.m_41613_());
            sender.m_150109_().m_36054_(toGive);
            QuestownNetwork.CHANNEL.send(PacketDistributor.PLAYER.with(() -> sender), (Object)new CloseScreensMessage());
            sender.f_36096_.m_38946_();
            Compat.sendMessage(sender, (Component)Compat.translatable("commands.give.success.single", 1, given.m_41611_(), sender.m_5446_()));
        });
        ctx.get().setPacketHandled(true);
    }
}

