/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.core.network;

import ca.bradj.questown.QT;
import ca.bradj.questown.gui.ItemEconomicsData;
import ca.bradj.questown.gui.TownEconomicsScreen;
import ca.bradj.questown.gui.VillagerEconomicsScreen;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public record EconomicsUpdate(ImmutableList<ItemEconomicsData> data) {
    public static void encode(EconomicsUpdate msg, FriendlyByteBuf buffer) {
        buffer.m_236828_(msg.data, (b, i) -> {
            b.m_130070_(i.ingredientKey());
            b.writeInt(i.timesNeeded());
        });
    }

    public static EconomicsUpdate decode(FriendlyByteBuf buffer) {
        List l = (List)buffer.m_236838_(ArrayList::new, b -> new ItemEconomicsData(b.m_130277_(), b.readInt()));
        return new EconomicsUpdate((ImmutableList<ItemEconomicsData>)ImmutableList.copyOf((Collection)l));
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            VillagerEconomicsScreen.lastUpdate = this;
            TownEconomicsScreen.lastUpdate = this;
        })).exceptionally(EconomicsUpdate::logError);
        ctx.get().setPacketHandled(true);
    }

    private static Void logError(Throwable ex) {
        String name = EconomicsUpdate.class.getName();
        QT.GUI_LOGGER.error("Failed to send {} data to player", (Object)name, (Object)ex);
        return null;
    }
}

