/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.core.network;

import ca.bradj.questown.QT;
import ca.bradj.questown.core.init.TilesInit;
import ca.bradj.questown.gui.BopTransactionSyncer;
import ca.bradj.questown.town.TownFlagBlockEntity;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.network.NetworkEvent;

public record JobRootChangeMessage(BlockPos flagPos, UUID villagerUUID, boolean instant) {
    public static void encode(JobRootChangeMessage msg, FriendlyByteBuf buffer) {
        buffer.m_130064_(msg.flagPos);
        buffer.m_130077_(msg.villagerUUID);
        buffer.writeBoolean(msg.instant());
    }

    public static JobRootChangeMessage decode(FriendlyByteBuf buffer) {
        BlockPos flagPos = buffer.m_130135_();
        UUID uuid = buffer.m_130259_();
        boolean instant = buffer.readBoolean();
        return new JobRootChangeMessage(flagPos, uuid, instant);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer sender = ((NetworkEvent.Context)ctx.get()).getSender();
            Optional flag = sender.m_9236_().m_141902_(this.flagPos, (BlockEntityType)TilesInit.TOWN_FLAG.get());
            if (flag.isEmpty()) {
                QT.GUI_LOGGER.error("No flag at position {}. Job root will not be changed.", (Object)this.flagPos);
                return;
            }
            BopTransactionSyncer.syncConsumedBOP(sender);
            ((TownFlagBlockEntity)flag.get()).getVillagerHandle().scheduleJobRootChange(this.villagerUUID, this.instant);
        });
        ctx.get().setPacketHandled(true);
    }
}

