/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.core.network;

import ca.bradj.questown.QT;
import ca.bradj.questown.core.Pair;
import ca.bradj.questown.core.UtilClean;
import ca.bradj.questown.gui.MultiStatusScreen;
import ca.bradj.questown.gui.SessionUniqueOrdinals;
import ca.bradj.questown.jobs.IStatus;
import ca.bradj.questown.jobs.JobID;
import ca.bradj.questown.jobs.Jobs;
import ca.bradj.questown.mc.Compat;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public record MultiStatusScreenSyncMessage(MultiStatusScreen.SyncedData data) {
    public static void encode(MultiStatusScreenSyncMessage msg, FriendlyByteBuf buffer) {
        buffer.m_236831_(msg.data.villagers(), FriendlyByteBuf::m_130077_, (b, v) -> {
            Jobs.writeIdToNetwork(b, (JobID)v.a());
            b.writeInt(SessionUniqueOrdinals.getOrdinal((IStatus)v.b()));
        });
        buffer.m_236831_(msg.data.items(), FriendlyByteBuf::m_130077_, (b, v) -> b.m_236828_((Collection)v, (bb, item) -> bb.m_130085_(Compat.getItemId(item))));
    }

    public static MultiStatusScreenSyncMessage decode(FriendlyByteBuf buffer) {
        HashMap data = (HashMap)buffer.m_236841_(HashMap::new, FriendlyByteBuf::m_130259_, b -> new Pair(Jobs.getIdFromNetwork(b), SessionUniqueOrdinals.getStatus(b.readInt())));
        HashMap data2 = (HashMap)buffer.m_236841_(HashMap::new, FriendlyByteBuf::m_130259_, MultiStatusScreenSyncMessage::readItemsFromBuffer);
        return new MultiStatusScreenSyncMessage(new MultiStatusScreen.SyncedData(data, data2));
    }

    @NotNull
    private static ImmutableList<Item> readItemsFromBuffer(FriendlyByteBuf b) {
        List dat = b.m_236845_(bb -> {
            ResourceLocation resourceLocation = b.m_130281_();
            try {
                return (Item)ForgeRegistries.ITEMS.getValue(resourceLocation);
            }
            catch (Exception e) {
                QT.GUI_LOGGER.error("Failed to get item {}", (Object)resourceLocation, (Object)e);
                return null;
            }
        });
        return ImmutableList.copyOf((Collection)dat);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            MultiStatusScreen.syncedData = new MultiStatusScreen.SyncedData((Map<UUID, Pair<JobID, IStatus<?>>>)ImmutableMap.copyOf(this.data.villagers()), UtilClean.deepCopy(this.data.items()));
        })).exceptionally(MultiStatusScreenSyncMessage::logError);
        ctx.get().setPacketHandled(true);
    }

    private static Void logError(Throwable ex) {
        QT.GUI_LOGGER.error("Failed to send villagers menu data to player", ex);
        return null;
    }
}

