/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.core.network;

import ca.bradj.questown.Questown;
import ca.bradj.questown.jobs.JobID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class NetworkCompat {
    public static ResourceLocation toRL(JobID id) {
        return Questown.ResourceLocation("jobs/%s/%s", id.rootId(), id.jobId());
    }

    public static JobID fromRL(ResourceLocation resourceLocation) {
        if (!resourceLocation.toString().startsWith("questown:jobs/")) {
            throw new IllegalArgumentException("Invalid ResourceLocation for JobID: " + String.valueOf(resourceLocation));
        }
        String[] parts = resourceLocation.toString().split("/");
        return new JobID(parts[1], parts[2]);
    }

    public static void toNetwork(FriendlyByteBuf buf, JobID jobID) {
        buf.m_130070_(jobID.rootId());
        buf.m_130070_(jobID.jobId());
    }

    public static JobID fromNetworkJobID(FriendlyByteBuf buf) {
        String rootId = buf.m_130277_();
        String jobId = buf.m_130277_();
        return new JobID(rootId, jobId);
    }

    @Nullable
    public static JobID fromNetworkJobIDNullable(FriendlyByteBuf buffer) {
        String parent = buffer.m_130277_();
        JobID p = null;
        if (!parent.equals("null")) {
            p = NetworkCompat.fromRL(new ResourceLocation(parent));
        }
        return p;
    }

    public static void toNetworkNullable(FriendlyByteBuf buffer, @Nullable JobID nullableJobId) {
        if (nullableJobId == null) {
            buffer.m_130070_("null");
        } else {
            buffer.m_130070_(NetworkCompat.toRL(nullableJobId).toString());
        }
    }
}

