/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.core.network;

import ca.bradj.questown.QT;
import ca.bradj.questown.gui.ClientAccess;
import ca.bradj.questown.mc.Compat;
import com.google.common.collect.ImmutableList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public record OnScreenTextMessage(String key, Object[] args) {
    public static void encode(OnScreenTextMessage msg, FriendlyByteBuf buffer) {
        buffer.m_130070_(msg.key());
        buffer.writeInt(msg.args.length);
        for (Object arg : msg.args) {
            buffer.m_130070_(arg.toString());
        }
    }

    public static OnScreenTextMessage decode(FriendlyByteBuf buffer) {
        String key = buffer.m_130277_();
        int numArgs = buffer.readInt();
        ImmutableList.Builder b = ImmutableList.builder();
        for (int i = 0; i < numArgs; ++i) {
            b.add((Object)buffer.m_130277_());
        }
        return new OnScreenTextMessage(key, b.build().toArray());
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        AtomicBoolean success = new AtomicBoolean(false);
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            ClientAccess.showHint((Component)Compat.translatable(this.key, this.args));
            success.set(true);
        })).exceptionally(OnScreenTextMessage::logError);
        ctx.get().setPacketHandled(true);
    }

    private static Void logError(Throwable ex) {
        QT.GUI_LOGGER.error("Failed to send wand message to player", ex);
        return null;
    }
}

