/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.core.network;

import ca.bradj.questown.QT;
import ca.bradj.questown.core.init.TilesInit;
import ca.bradj.questown.town.TownFlagBlockEntity;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.network.NetworkEvent;

public record OpenVillagerMenuMessage(int flagX, int flagY, int flagZ, UUID villagerUUID, String type) {
    public static final String INVENTORY = "inventory";
    public static final String QUESTS = "quests";
    public static final String STATS = "stats";
    public static final String SKILLS = "skills";
    public static final String CHANGE_ROOT = "change_root";
    public static final String ECONOMICS = "economics";
    public static final String BOP = "bop";

    public static void encode(OpenVillagerMenuMessage msg, FriendlyByteBuf buffer) {
        buffer.writeInt(msg.flagX());
        buffer.writeInt(msg.flagY());
        buffer.writeInt(msg.flagZ());
        buffer.m_130077_(msg.villagerUUID());
        buffer.m_130070_(msg.type());
    }

    public static OpenVillagerMenuMessage decode(FriendlyByteBuf buffer) {
        int flagX = buffer.readInt();
        int flagY = buffer.readInt();
        int flagZ = buffer.readInt();
        UUID id = buffer.m_130259_();
        String type = buffer.m_130277_();
        return new OpenVillagerMenuMessage(flagX, flagY, flagZ, id, type);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer sender = ((NetworkEvent.Context)ctx.get()).getSender();
            Optional flag = sender.m_9236_().m_141902_(new BlockPos(this.flagX, this.flagY, this.flagZ), (BlockEntityType)TilesInit.TOWN_FLAG.get());
            if (flag.isEmpty()) {
                QT.GUI_LOGGER.error("No flag at position {}, {}, {}. Quest will not be removed.", (Object)this.flagX, (Object)this.flagY, (Object)this.flagZ);
                return;
            }
            ((TownFlagBlockEntity)flag.get()).getVillagerHandle().showUI(sender, this.type(), this.villagerUUID());
        }).exceptionally(ex -> {
            QT.GUI_LOGGER.error("Failed to open villager menu", ex);
            return null;
        });
        ctx.get().setPacketHandled(true);
    }
}

