/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.gui;

import ca.bradj.questown.core.network.QuestownNetwork;
import ca.bradj.questown.core.network.RemoveQuestFromUIMessage;
import ca.bradj.questown.gui.FlagTabsEmbedding;
import ca.bradj.questown.gui.UIQuest;
import ca.bradj.questown.town.special.SpecialQuests;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;

public abstract class AbstractQuestsContainer
extends AbstractContainerMenu {
    protected final Collection<UIQuest> quests;
    protected final FlagTabsEmbedding.FlagInfo flagInfo;

    public AbstractQuestsContainer(MenuType<?> townQuestsContainerMenuType, int windowId, Collection<UIQuest> quests, FlagTabsEmbedding.FlagInfo flagInfo) {
        super(townQuestsContainerMenuType, windowId);
        this.quests = quests;
        this.flagInfo = flagInfo;
    }

    protected static void writeQuests(FriendlyByteBuf data, List<UIQuest> quests) {
        UIQuest.Serializer ser = new UIQuest.Serializer();
        data.writeInt(quests.size());
        data.m_236828_(quests, (buf, q) -> {
            ResourceLocation id;
            if (q == null) {
                q = UIQuest.BROKEN;
                id = SpecialQuests.BROKEN;
            } else {
                id = q.getWantedId();
            }
            buf.m_130085_(id);
            ser.toNetwork((FriendlyByteBuf)buf, (UIQuest)q);
        });
    }

    public static Collection<UIQuest> readQuests(FriendlyByteBuf data) {
        int size = data.readInt();
        ArrayList r = (ArrayList)data.m_236838_(c -> new ArrayList(size), buf -> {
            ResourceLocation recipeID = buf.m_130281_();
            return new UIQuest.Serializer().fromNetwork(recipeID, (FriendlyByteBuf)buf);
        });
        r.sort(UIQuest::compareTo);
        return r;
    }

    protected static void writeFlagPos(FriendlyByteBuf data, BlockPos pos) {
        data.writeInt(pos.m_123341_());
        data.writeInt(pos.m_123342_());
        data.writeInt(pos.m_123343_());
    }

    public static BlockPos readFlagPos(FriendlyByteBuf data) {
        return new BlockPos(data.readInt(), data.readInt(), data.readInt());
    }

    public boolean m_6875_(Player p_38874_) {
        return true;
    }

    public Collection<UIQuest> GetQuests() {
        return this.quests;
    }

    public void sendRemoveRequest(UUID batchUUID) {
        BlockPos f = this.flagInfo.flagPos();
        QuestownNetwork.CHANNEL.sendToServer((Object)new RemoveQuestFromUIMessage(batchUUID, f.m_123341_(), f.m_123342_(), f.m_123343_(), true));
    }

    public ItemStack m_7648_(Player p_38941_, int p_38942_) {
        return ItemStack.f_41583_;
    }
}

