/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.gui;

import ca.bradj.questown.gui.AddWorkContainer;
import ca.bradj.questown.mc.Compat;
import ca.bradj.questown.mc.JEI;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.common.util.ImmutableRect2i;
import mezz.jei.common.util.MathUtil;
import mezz.jei.gui.elements.GuiIconButtonSmall;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public class AddWorkScreen
extends AbstractContainerScreen<AddWorkContainer> {
    private static final int backgroundWidth = 176;
    private static final int backgroundHeight = 166;
    private static final int borderPadding = 6;
    private static final int buttonWidth = 13;
    private static final int buttonHeight = 13;
    private static final int TEXT_COLOR = 0x404040;
    private static final int CARD_PADDING = 1;
    private static final int PAGE_PADDING = 10;
    private static final int CARD_WIDTH = 156;
    private static final int CARD_HEIGHT = 42;
    private static final int MAX_CARDS_PER_PAGE = 3;
    private final List<Ingredient> work;
    private final JEI.NineNine background;
    private final JEI.NineNine cardBackground;
    private final GuiIconButtonSmall nextPage;
    private final GuiIconButtonSmall previousPage;
    private int currentPage = 0;
    private List<Slot> slots = new ArrayList<Slot>();

    public AddWorkScreen(AddWorkContainer container, Inventory playerInv, Component title) {
        super((AbstractContainerMenu)container, playerInv, title);
        this.f_97726_ = 256;
        this.f_97727_ = 220;
        this.work = ImmutableList.copyOf(container.getAddableWork());
        this.background = JEI.getRecipeGuiBackground();
        this.cardBackground = JEI.getRecipeBackground();
        IDrawableStatic arrowNext = JEI.getArrowNext();
        IDrawableStatic arrowPrevious = JEI.getArrowPrevious();
        this.nextPage = JEI.guiIconButtonSmall(0, 0, 13, 13, (IDrawable)arrowNext, b -> this.nextPage());
        this.previousPage = JEI.guiIconButtonSmall(0, 0, 13, 13, (IDrawable)arrowPrevious, b -> this.previousPage());
    }

    protected void m_7856_() {
        int y = (this.f_96544_ - 166) / 2;
        int pageStringY = y + 6;
        int x = (this.f_96543_ - 176) / 2;
        this.previousPage.f_93620_ = x + 6;
        this.previousPage.f_93621_ = pageStringY;
        this.nextPage.f_93620_ = x + 176 - 13 - 6;
        this.nextPage.f_93621_ = pageStringY;
        this.m_142416_((GuiEventListener)this.previousPage);
        this.m_142416_((GuiEventListener)this.nextPage);
    }

    public boolean m_7920_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 81) {
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(poseStack);
        super.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        int x = (this.f_96543_ - 176) / 2;
        int y = (this.f_96544_ - 166) / 2;
        int pageStringY = y + 10;
        this.renderPageNum(poseStack, x);
        y = pageStringY + 10;
        int startIndex = this.currentPage * 3;
        int endIndex = Math.min(startIndex + 3, this.work.size());
        ImmutableList.Builder b = ImmutableList.builder();
        ImmutableList<Slot> slotz = this.renderRequestItemIcons(poseStack, this.work, x += 10, y += 10, mouseX, mouseY);
        b.addAll(slotz);
        int idX = x + 10;
        int idY = y - 10;
        this.f_96547_.m_92889_(poseStack, Compat.translatable("job_board.add_work.title"), (float)idX, (float)idY, 0x404040);
        this.slots.clear();
        this.slots.addAll((Collection<Slot>)b.build());
        this.previousPage.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        this.nextPage.m_6305_(poseStack, mouseX, mouseY, partialTicks);
    }

    private ImmutableList<Slot> renderRequestItemIcons(PoseStack poseStack, Iterable<Ingredient> possibleRequests, int x, int y, int mouseX, int mouseY) {
        Inventory dummyInv = new Inventory(null);
        ImmutableList.Builder b = ImmutableList.builder();
        int slotIndex = 0;
        int slotX = 0;
        for (Ingredient ing : possibleRequests) {
            if (slotX >= 8) {
                y += 16;
                slotX = 0;
            }
            int iconX = x + 8 + slotX * 18;
            ItemStack[] allPossible = ing.m_43908_();
            if (allPossible.length > 0) {
                int curSeconds = (int)(System.currentTimeMillis() / 1000L);
                ItemStack itemStack = allPossible[curSeconds % allPossible.length];
                this.renderRequest(poseStack, y, mouseX, mouseY, itemStack, iconX, dummyInv, slotIndex, (ImmutableList.Builder<Slot>)b);
                ++slotIndex;
                ++slotX;
            }
            if (allPossible.length == 1) continue;
            for (ItemStack specificItem : allPossible) {
                if (slotX >= 8) {
                    y += 16;
                    slotX = 0;
                }
                iconX = x + 8 + slotX * 18;
                this.renderRequest(poseStack, y, mouseX, mouseY, specificItem, iconX, dummyInv, slotIndex, (ImmutableList.Builder<Slot>)b);
                ++slotIndex;
                ++slotX;
            }
        }
        return b.build();
    }

    private void renderRequest(PoseStack poseStack, int y, int mouseX, int mouseY, ItemStack itemStack, int iconX, Inventory dummyInv, int slotIndex, ImmutableList.Builder<Slot> b) {
        this.f_96542_.m_115203_(itemStack, iconX, y + 1);
        if (mouseX >= iconX && mouseY >= y && mouseX < iconX + 16 && mouseY < y + 17) {
            AddWorkScreen.m_93172_((PoseStack)poseStack, (int)iconX, (int)(y + 1), (int)(iconX + 16), (int)(y + 17), (int)-2130706433);
            this.m_96602_(poseStack, itemStack.m_41720_().m_7626_(itemStack), mouseX, mouseY);
        }
        Slot element = new Slot((Container)dummyInv, slotIndex, iconX, y + 1);
        element.m_5852_(itemStack);
        b.add((Object)element);
    }

    private void renderPageNum(PoseStack poseStack, int x) {
        AddWorkScreen.m_93172_((PoseStack)poseStack, (int)(x + 6 + 13), (int)this.nextPage.f_93621_, (int)(x + 176 - 6 - 13), (int)(this.nextPage.f_93621_ + 13), (int)0x30000000);
        int totalPages = (int)Math.ceil((double)this.work.size() / 3.0);
        String pageString = "Page " + (this.currentPage + 1) + " / " + totalPages;
        ImmutableRect2i pageArea = MathUtil.union((ImmutableRect2i)this.previousPage.getArea(), (ImmutableRect2i)this.nextPage.getArea());
        ImmutableRect2i textArea = MathUtil.centerTextArea((ImmutableRect2i)pageArea, (Font)this.f_96547_, (String)pageString);
        Compat.drawLightText(this.f_96547_, poseStack, pageString, textArea.getX(), textArea.getY());
    }

    protected void m_7286_(PoseStack poseStack, float partialTicks, int mouseX, int mouseY) {
        int x = (this.f_96543_ - 176) / 2;
        int y = (this.f_96544_ - 166) / 2;
        this.background.draw(poseStack, x, y, 176, 166);
    }

    private void renderSlot(PoseStack poseStack, Slot slot, int mouseX, int mouseY, float partialTicks) {
        ItemStack stack = slot.m_7993_();
        if (!stack.m_41619_()) {
            this.f_96541_.m_91291_().m_115123_(stack, slot.f_40220_, slot.f_40221_);
            this.f_96541_.m_91291_().m_115174_(this.f_96547_, stack, slot.f_40220_, slot.f_40221_, "");
        }
    }

    private void nextPage() {
        int totalPages = (int)Math.ceil((double)this.work.size() / 3.0);
        if (this.currentPage < totalPages - 1) {
            ++this.currentPage;
        }
    }

    private void previousPage() {
        if (this.currentPage > 0) {
            --this.currentPage;
        }
    }

    public boolean m_7043_() {
        return false;
    }

    public List<Rect2i> getExtraAreas() {
        int x = (this.f_96543_ - 176) / 2;
        int y = (this.f_96544_ - 166) / 2;
        return ImmutableList.of((Object)new Rect2i(x, y, 176, 166));
    }

    public ItemStack getHoveredIngredient(int mouseX, int mouseY) {
        Predicate<Slot> slotPredicate = s -> mouseX >= s.f_40220_ && mouseX <= s.f_40220_ + 16 && mouseY >= s.f_40221_ + 1 && mouseY <= s.f_40221_ + 17;
        Stream<Slot> matches = this.slots.stream().filter(slotPredicate);
        Optional<Slot> found = matches.findAny();
        return found.map(Slot::m_7993_).orElse(ItemStack.f_41583_);
    }

    public boolean m_6050_(double scrollX, double scrollY, double scrollDelta) {
        double y;
        double x = JEI.getX();
        if (this.m_5953_(x, y = JEI.getY())) {
            if (scrollDelta < 0.0) {
                this.nextPage();
                return true;
            }
            if (scrollDelta > 0.0) {
                this.previousPage();
                return true;
            }
        }
        return super.m_6050_(scrollX, scrollY, scrollDelta);
    }

    public boolean m_6375_(double x, double y, int p_97750_) {
        for (Slot s : this.slots) {
            if (!((double)s.f_40220_ < x) || !((double)(s.f_40220_ + 16) > x) || !((double)s.f_40221_ < y) || !((double)(s.f_40221_ + 16) > y)) continue;
            ((AddWorkContainer)this.f_97732_).sendRequest(Ingredient.m_43927_((ItemStack[])new ItemStack[]{s.m_7993_()}));
            return true;
        }
        return super.m_6375_(x, y, p_97750_);
    }

    public boolean m_5953_(double mouseX, double mouseY) {
        return true;
    }
}

