/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.gui;

import ca.bradj.questown.core.init.MenuTypesInit;
import ca.bradj.questown.core.network.CreateStockRequestFromUIMessage;
import ca.bradj.questown.core.network.QuestownNetwork;
import ca.bradj.questown.jobs.requests.WorkRequest;
import com.google.common.collect.ImmutableCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public class CreateStockRequestContainer
extends AbstractContainerMenu {
    private final Collection<Ingredient> work;
    private final BlockPos flag;

    public CreateStockRequestContainer(int windowId, Collection<Ingredient> work, BlockPos flag) {
        super((MenuType)MenuTypesInit.CREATE_STOCK_REQUEST.get(), windowId);
        this.work = work;
        this.flag = flag;
    }

    public static CreateStockRequestContainer ForClientSide(int i, Inventory inventory, FriendlyByteBuf buf) {
        return new CreateStockRequestContainer(i, CreateStockRequestContainer.readWorkResults(buf), CreateStockRequestContainer.readFlagPosition(buf));
    }

    public static Collection<Ingredient> readWorkResults(FriendlyByteBuf data) {
        int size = data.readInt();
        ArrayList r = (ArrayList)data.m_236838_(c -> new ArrayList(size), Ingredient::m_43940_);
        return r;
    }

    public static void writeWorkResults(ImmutableCollection<Ingredient> allOutputs, FriendlyByteBuf data) {
        data.writeInt(allOutputs.size());
        data.m_236828_(allOutputs, (v, i) -> i.m_43923_(v));
    }

    public static BlockPos readFlagPosition(FriendlyByteBuf buf) {
        return buf.m_130135_();
    }

    public static void writeFlagPosition(BlockPos blockPos, FriendlyByteBuf data) {
        data.m_130064_(blockPos);
    }

    public ItemStack m_7648_(Player player, int i) {
        return ItemStack.f_41583_;
    }

    public boolean m_6875_(Player p_38874_) {
        return true;
    }

    public Collection<Ingredient> getAddableWork() {
        return this.work;
    }

    public void sendRequest(WorkRequest item, UUID uuid) {
        QuestownNetwork.CHANNEL.sendToServer((Object)new CreateStockRequestFromUIMessage(item, this.flag.m_123341_(), this.flag.m_123342_(), this.flag.m_123343_(), uuid));
    }
}

