/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.gui;

import ca.bradj.questown.QT;
import ca.bradj.questown.core.Pair;
import ca.bradj.questown.core.network.MultiStatusScreenSyncMessage;
import ca.bradj.questown.core.network.QuestownNetwork;
import ca.bradj.questown.gui.FlagTabsEmbedding;
import ca.bradj.questown.gui.MultiStatusMenu;
import ca.bradj.questown.gui.MultiStatusScreen;
import ca.bradj.questown.gui.TownBlockofProgressMenu;
import ca.bradj.questown.gui.TownEconomicsMenu;
import ca.bradj.questown.gui.TownQuestsContainer;
import ca.bradj.questown.gui.UIQuest;
import ca.bradj.questown.gui.VillagerQuestsContainer;
import ca.bradj.questown.jobs.IStatus;
import ca.bradj.questown.jobs.StatusListener;
import ca.bradj.questown.mobs.visitor.VisitorMobEntity;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

public class FlagMenus {
    TownQuestsContainer questsMenu;
    MultiStatusMenu villagersMenu;
    TownEconomicsMenu econMenu;
    TownBlockofProgressMenu bopMenu;

    public static FlagMenus fromNetwork(int windowId, Player player, FriendlyByteBuf buf) {
        try {
            Collection<UIQuest> quests = VillagerQuestsContainer.readQuests(buf);
            BlockPos flagPos = VillagerQuestsContainer.readFlagPos(buf);
            int blocksOfProgress = TownBlockofProgressMenu.read(buf);
            FlagTabsEmbedding.FlagInfo flagInfo = new FlagTabsEmbedding.FlagInfo(flagPos, blocksOfProgress > 0);
            FlagMenus menus = new FlagMenus();
            menus.initQuestsMenuClientSide(windowId, quests, flagInfo);
            menus.initMultiVillagerStatusMenuClientSide(windowId, flagInfo);
            menus.initEconClientSide(windowId, flagInfo);
            menus.initBlocksOfProgress(windowId, flagInfo, blocksOfProgress);
            return menus;
        }
        catch (Exception e) {
            QT.GUI_LOGGER.error("Failed to open town quests container: {}", (Object)e.getMessage());
            throw e;
        }
    }

    public static void writeAndLink(FriendlyByteBuf data, List<UIQuest> quests, FlagTabsEmbedding.FlagInfo flagInfo, final ServerPlayer player, final Iterable<? extends VisitorMobEntity> es, int bopCount) {
        TownQuestsContainer.write(data, quests, flagInfo.flagPos());
        MultiStatusScreenSyncMessage msg = new MultiStatusScreenSyncMessage(FlagMenus.makeSyncData(es));
        QuestownNetwork.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)msg);
        for (VisitorMobEntity visitorMobEntity : es) {
            visitorMobEntity.addStatusListener(new StatusListener(){

                @Override
                public Runnable jobChanged(Function<StatusListener, Runnable> listenToNewJob) {
                    return listenToNewJob.apply(this);
                }

                @Override
                public void statusChanged(IStatus<?> newStatus) {
                    MultiStatusScreen.SyncedData data1 = FlagMenus.makeSyncData(es);
                    QuestownNetwork.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new MultiStatusScreenSyncMessage(data1));
                }
            });
        }
        TownBlockofProgressMenu.write(data, flagInfo, bopCount);
    }

    private static @NotNull MultiStatusScreen.SyncedData makeSyncData(Iterable<? extends VisitorMobEntity> es) {
        HashMap b = new HashMap();
        HashMap<UUID, ImmutableList<Item>> b2 = new HashMap<UUID, ImmutableList<Item>>();
        for (VisitorMobEntity visitorMobEntity : es) {
            if (b.containsKey(visitorMobEntity.m_20148_()) || b.containsKey(visitorMobEntity.m_20148_())) {
                QT.FLAG_LOGGER.error("Villager {} detected twice. This is probably a bug!", (Object)visitorMobEntity.m_20148_());
            }
            b.put(visitorMobEntity.m_20148_(), new Pair(visitorMobEntity.getJobId(), visitorMobEntity.getStatusForServer()));
            List<Item> list = visitorMobEntity.getJobJournalSnapshot().items().stream().map(z -> z.get().get()).toList();
            b2.put(visitorMobEntity.m_20148_(), (ImmutableList<Item>)ImmutableList.copyOf(list));
        }
        MultiStatusScreen.SyncedData data1 = new MultiStatusScreen.SyncedData(b, b2);
        return data1;
    }

    public void initQuestsMenuClientSide(int windowId, Collection<UIQuest> quests, FlagTabsEmbedding.FlagInfo flag) {
        this.questsMenu = new TownQuestsContainer(windowId, quests, flag, () -> {});
    }

    public void initMultiVillagerStatusMenuClientSide(int windowId, FlagTabsEmbedding.FlagInfo flag) {
        this.villagersMenu = new MultiStatusMenu(windowId, flag, () -> {});
    }

    private void initEconClientSide(int windowId, FlagTabsEmbedding.FlagInfo flag) {
        this.econMenu = new TownEconomicsMenu(windowId, flag);
    }

    private void initBlocksOfProgress(int windowId, FlagTabsEmbedding.FlagInfo flagPos, int blocksOfProgress) {
        this.bopMenu = new TownBlockofProgressMenu(windowId, flagPos, blocksOfProgress);
    }
}

