/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.gui;

import ca.bradj.questown.jobs.requests.WorkRequest;
import ca.bradj.questown.mc.Compat;
import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import java.util.List;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class Ingredients {
    public static Component getName(Ingredient item) {
        String tKey;
        Item i;
        JsonElement j = item.m_43942_();
        String tag = Ingredients.getTag(j);
        if (tag != null) {
            return Compat.translatable("#" + tag);
        }
        if (j.isJsonObject() && j.getAsJsonObject().has("item") && (i = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(tKey = j.getAsJsonObject().get("item").getAsString()))) != null) {
            return i.m_7626_(i.m_7968_());
        }
        return Compat.translatable("this");
    }

    public static WorkRequest asWorkRequest(Ingredient item) {
        String tKey;
        Item i;
        JsonElement j = item.m_43942_();
        String tag = Ingredients.getTag(j);
        if (tag != null) {
            return WorkRequest.of((TagKey<Item>)new TagKey(Registry.f_122904_, new ResourceLocation(tag)));
        }
        if (j.isJsonObject() && j.getAsJsonObject().has("item") && (i = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(tKey = j.getAsJsonObject().get("item").getAsString()))) != null) {
            return WorkRequest.of(i);
        }
        throw new IllegalArgumentException("Ingredient has no item or tag");
    }

    public static Ingredient fromString(String block) {
        if (block.startsWith("#")) {
            return Ingredient.m_204132_((TagKey)TagKey.m_203882_((ResourceKey)Registry.f_122904_, (ResourceLocation)new ResourceLocation(block.replace("#", ""))));
        }
        return Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation(block))});
    }

    public static String toString(Ingredient item) {
        JsonElement j = item.m_43942_();
        String tag = Ingredients.getTag(j);
        if (tag != null) {
            String tKey = "#" + tag;
            return tKey;
        }
        if (j.isJsonObject() && j.getAsJsonObject().has("item")) {
            String tKey = j.getAsJsonObject().get("item").getAsString();
            return tKey;
        }
        throw new IllegalArgumentException("Ingredient must have tag or item");
    }

    @Nullable
    public static String getTag(Ingredient ing) {
        JsonElement j = ing.m_43942_();
        return Ingredients.getTag(j);
    }

    @Nullable
    private static String getTag(JsonElement j) {
        if (!j.isJsonObject()) {
            return null;
        }
        if (!j.getAsJsonObject().has("tag")) {
            return null;
        }
        return j.getAsJsonObject().get("tag").getAsString();
    }

    @Nullable
    public static ItemStack render(ItemRenderer itemRenderer, Ingredient ing, int iconX, int y) {
        int curSeconds = (int)(System.currentTimeMillis() / 1000L);
        ItemStack[] matchingStacks = ing.m_43908_();
        if (matchingStacks.length > 0) {
            ItemStack itemStack = matchingStacks[curSeconds % matchingStacks.length];
            itemRenderer.m_115203_(itemStack, iconX, y + 1);
            return itemStack;
        }
        return null;
    }

    public static Ingredient fromNetwork(FriendlyByteBuf buffer) {
        return Ingredients.fromString(buffer.m_130277_());
    }

    public static void toNetwork(Ingredient requested, FriendlyByteBuf buffer) {
        buffer.m_130070_(Ingredients.toString(requested));
    }

    public static Ingredient fromRL(ResourceLocation value) {
        @Nullable Item l = (Item)ForgeRegistries.ITEMS.getValue(value);
        return Ingredient.m_43929_((ItemLike[])new ItemLike[]{l});
    }

    public static List<Ingredient> fromItems(ImmutableList<ItemStack> result) {
        return result.stream().filter(v -> !v.m_41619_()).map(xva$0 -> Ingredient.m_43927_((ItemStack[])new ItemStack[]{xva$0})).toList();
    }

    public static boolean equal(Ingredient z, Ingredient requestedItem) {
        return Ingredients.toString(z).equals(Ingredients.toString(requestedItem));
    }

    public static boolean isTag(Ingredient requestedItem) {
        return Ingredients.getTag(requestedItem) != null;
    }
}

