/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.gui;

import ca.bradj.questown.core.Pair;
import ca.bradj.questown.core.UtilClean;
import ca.bradj.questown.gui.AbstractPagedCardScreen;
import ca.bradj.questown.gui.FlagTabs;
import ca.bradj.questown.gui.JobTooltips;
import ca.bradj.questown.gui.MultiStatusMenu;
import ca.bradj.questown.gui.PagedCardScreen;
import ca.bradj.questown.gui.RenderContext;
import ca.bradj.questown.jobs.IStatus;
import ca.bradj.questown.jobs.JobID;
import ca.bradj.questown.jobs.ServerJobsRegistry;
import ca.bradj.questown.jobs.production.ProductionStatus;
import ca.bradj.questown.mc.Compat;
import ca.bradj.questown.mc.Util;
import com.google.common.collect.EvictingQueue;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class MultiStatusScreen
extends AbstractPagedCardScreen<MultiStatusMenu, UUID> {
    private final Map<UUID, Collection<IStatus<?>>> statusSmoothingQueue = new HashMap();
    private final FlagTabs tabs;
    public static SyncedData syncedData = new SyncedData(new HashMap(), new HashMap<UUID, ImmutableList<Item>>());

    public MultiStatusScreen(MultiStatusMenu menu, Inventory playerInv, Component title) {
        super(menu, new Inventory(null){

            public Component m_5446_() {
                return Compat.literal("");
            }
        }, Compat.literal(""));
        this.tabs = FlagTabs.forMenu(menu);
    }

    @Override
    public void m_6305_(PoseStack stack, int mouseX, int mouseY, float partialTicks) {
        int bgX = (this.f_96543_ - 176) / 2;
        int bgY = (this.f_96544_ - super.backgroundHeight()) / 2;
        super.m_7333_(stack);
        super.m_6305_(stack, mouseX, mouseY, partialTicks);
        this.tabs.draw(new RenderContext(this.f_96542_, stack), bgX, bgY);
        this.m_7025_(stack, mouseX, mouseY);
    }

    @Override
    protected ImmutableList<UUID> cardsData() {
        return ImmutableList.copyOf(MultiStatusScreen.syncedData.villagers.keySet());
    }

    @Override
    protected List<Component> renderCardContent(PoseStack poseStack, PagedCardScreen.Card<UUID> card, int mouseX, int mouseY) {
        this.renderStatus(poseStack, card.coords(), card.data());
        this.renderInventory(card.coords(), card.data());
        this.renderFace(poseStack, card.coords(), card.data());
        return null;
    }

    private void renderInventory(PagedCardScreen.CardCoordinates coords, UUID uuid) {
        int iconX = coords.leftXPadded();
        Collection items = (Collection)MultiStatusScreen.syncedData.items.get(uuid);
        for (Item item : items) {
            int destX = iconX + 1;
            int destY = coords.topYPadded() + 10;
            this.f_96542_.m_115203_(new ItemStack((ItemLike)item), destX, destY);
            iconX += 16;
        }
    }

    private void renderFace(PoseStack stack, PagedCardScreen.CardCoordinates coords, UUID uuid) {
        int x = coords.leftXPadded();
        int destY = coords.topYPadded();
        Util.blitFace(stack, uuid, x, destY);
        int nameX = x + 8 + 4;
        Compat.drawDarkText(this.f_96547_, stack, Compat.translatable(MultiStatusScreen.syncedData.villagers.get(uuid).a().rootId()), nameX, destY);
    }

    private void renderStatus(PoseStack stack, PagedCardScreen.CardCoordinates coords, UUID uuid) {
        int drawWidth = 32;
        int drawHeight = 32;
        int texWidth = 32;
        int texHeight = 32;
        int destX = coords.rightXPadded() - drawWidth;
        int destY = coords.topYPadded() - 5;
        IStatus<?> status = this.getSmoothedStatus(uuid);
        JobID job = MultiStatusScreen.syncedData.villagers.get(uuid).a();
        ResourceLocation texture = ServerJobsRegistry.getTexture(job, status);
        RenderSystem.m_157456_((int)0, (ResourceLocation)texture);
        MultiStatusScreen.m_93133_((PoseStack)stack, (int)destX, (int)destY, (float)0.0f, (float)0.0f, (int)drawWidth, (int)drawHeight, (int)texWidth, (int)texHeight);
    }

    @NotNull
    private IStatus<?> getSmoothedStatus(UUID villagerUUID) {
        Collection<IStatus<?>> q = UtilClean.getOrDefaultCollection(this.statusSmoothingQueue, villagerUUID, EvictingQueue.create((int)5), true);
        q.add(MultiStatusScreen.syncedData.villagers.get(villagerUUID).b());
        this.statusSmoothingQueue.put(villagerUUID, q);
        HashMap<IStatus, Integer> counter = new HashMap<IStatus, Integer>();
        for (IStatus<?> iStatus : q) {
            counter.compute(iStatus, (ignored, oldCt) -> oldCt == null ? 1 : oldCt + 1);
        }
        return counter.entrySet().stream().max(Comparator.comparingInt(Map.Entry::getValue)).map(Map.Entry::getKey).orElseThrow();
    }

    protected void m_7025_(@NotNull PoseStack stack, int mouseX, int mouseY) {
        int bgX = (this.f_96543_ - 176) / 2;
        int bgY = (this.f_96544_ - this.backgroundHeight()) / 2;
        if (this.tabs.renderTooltip(bgX, bgY, mouseX, mouseY, key -> super.m_96602_(stack, Compat.translatable(key), mouseX, mouseY))) {
            return;
        }
        bgY = bgY + 10 + 10;
        int leftX = bgX + 176 - 16 - 32;
        int topY = bgY + 16;
        int rightX = leftX + 32;
        int botY = topY + 32;
        ImmutableList<UUID> uuids = this.cardsData();
        for (int i = 0; i < uuids.size(); ++i) {
            if (mouseX < leftX || mouseX > rightX || mouseY < topY + i * this.cardHeight || mouseY > botY + i * this.cardHeight) continue;
            UUID villagerUUID = (UUID)uuids.get(i);
            IStatus<?> status = this.getSmoothedStatus(villagerUUID);
            JobID jobId = syncedData.villagers().get(villagerUUID).a();
            ImmutableList<Component> components = JobTooltips.get((ProductionStatus)status, jobId);
            super.m_169388_(stack, components, Optional.empty(), mouseX, mouseY);
            return;
        }
        super.m_7025_(stack, mouseX, mouseY);
    }

    public boolean m_6375_(double p_97748_, double p_97749_, int p_97750_) {
        int bgX = (this.f_96543_ - 176) / 2;
        int bgY = (this.f_96544_ - this.backgroundHeight()) / 2;
        this.tabs.mouseClicked(bgX, bgY, p_97748_, p_97749_);
        return super.m_6375_(p_97748_, p_97749_, p_97750_);
    }

    @Override
    protected void setRenderColorForCard(UUID uuid) {
    }

    public record SyncedData(Map<UUID, Pair<JobID, IStatus<?>>> villagers, Map<UUID, ImmutableList<Item>> items) {
    }
}

