/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.gui;

import ca.bradj.questown.core.Coordinate;
import ca.bradj.questown.core.UtilClean;
import ca.bradj.questown.mc.Compat;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.apache.logging.log4j.util.BiConsumer;
import org.jetbrains.annotations.Nullable;

public class RenderUtil {
    public static final int SHADOW = 0x30000000;
    public static final int HIGHLIGHT = -2130706433;

    @Nullable
    public static List<Component> renderEllipsesAndReturnTooltip(EllipsesData data, BiConsumer<Component, Coordinate> renderDarkText, BiConsumer<Coordinate, Coordinate> renderHighlight) {
        int itemX = data.topLeft.x() + 24 * data.maxItemsBeforeEllipses;
        Coordinate squareTopLeft = new Coordinate(itemX, data.topLeft.y());
        renderDarkText.accept((Object)Compat.literal("\u2026"), (Object)squareTopLeft.shifted(4, 2));
        if (UtilClean.isCoordInBox(data.mouse, squareTopLeft.shifted(-4, 0), squareTopLeft.shifted(20, 16))) {
            return RenderUtil.getEllipseTooltip(data, renderHighlight, itemX);
        }
        return null;
    }

    @Nullable
    private static List<Component> getEllipseTooltip(EllipsesData data, BiConsumer<Coordinate, Coordinate> renderHighlight, int itemX) {
        Coordinate itemTopLeft = new Coordinate(itemX, data.topLeft.y());
        renderHighlight.accept((Object)itemTopLeft, (Object)itemTopLeft.shifted(16, 16));
        MutableComponent andMore = Compat.translatable("menu.work_add_confirm.and_n_more", data.totalItemCount - data.maxItemsBeforeEllipses);
        return ImmutableList.of((Object)andMore);
    }

    @Nullable
    public static <ITEM> List<Component> stripOfRequestableItems(BiConsumer<ITEM, Coordinate> renderIngredient, Function<ITEM, ImmutableList<Component>> tooltipText, BiConsumer<Component, Coordinate> renderDarkText, BiConsumer<Coordinate, Coordinate> renderHighlight, List<ITEM> d, Coordinate topLeft, Coordinate bottomRight, Coordinate mouse) {
        ImmutableList<Component> tooltips = null;
        int maxItemsOnX = (bottomRight.x() - topLeft.x()) / 24;
        for (int i = 0; i < Math.min(maxItemsOnX, d.size()); ++i) {
            ITEM ing = d.get(i);
            Coordinate iTopLeft = new Coordinate(topLeft.x() + i * 24, topLeft.y());
            renderIngredient.accept(ing, (Object)iTopLeft);
            Coordinate iBotRight = iTopLeft.shifted(16, 16);
            if (!UtilClean.isCoordInBox(mouse, iTopLeft.shifted(-4, 0), iBotRight.shifted(4, 0))) continue;
            renderHighlight.accept((Object)iTopLeft, (Object)iBotRight);
            tooltips = tooltipText.apply(ing);
        }
        List<Component> ellipseTooltips = null;
        if (d.size() > maxItemsOnX) {
            EllipsesData data = new EllipsesData(mouse, topLeft, maxItemsOnX, d.size());
            ellipseTooltips = RenderUtil.renderEllipsesAndReturnTooltip(data, renderDarkText, renderHighlight);
        }
        if (tooltips != null) {
            return tooltips;
        }
        return ellipseTooltips;
    }

    public static void highlight(PoseStack stack, Coordinate topLeft, Coordinate botRight) {
        GuiComponent.m_93172_((PoseStack)stack, (int)topLeft.x(), (int)topLeft.y(), (int)botRight.x(), (int)botRight.y(), (int)-2130706433);
    }

    public static void renderItemScaled(ItemRenderer itemRenderer, int scale, ItemStack defaultInstance, int x, int y) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)TextureAtlas.f_118259_);
        RenderSystem.m_69478_();
        RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        PoseStack posestack = RenderSystem.m_157191_();
        posestack.m_85836_();
        posestack.m_85837_((double)x, (double)y, (double)(100.0f + itemRenderer.f_115093_));
        posestack.m_85837_(8.0, 8.0, 0.0);
        posestack.m_85841_(1.0f, -1.0f, 1.0f);
        float size = 16.0f * (float)scale;
        posestack.m_85841_(size, size, size);
        RenderSystem.m_157182_();
        PoseStack posestack1 = new PoseStack();
        MultiBufferSource.BufferSource multibuffersource$buffersource = Minecraft.m_91087_().m_91269_().m_110104_();
        itemRenderer.m_115143_(defaultInstance, ItemTransforms.TransformType.GUI, false, posestack1, (MultiBufferSource)multibuffersource$buffersource, 0xF000F0, OverlayTexture.f_118083_, itemRenderer.m_174264_(defaultInstance, null, null, 0));
        multibuffersource$buffersource.m_109911_();
        RenderSystem.m_69482_();
        posestack.m_85849_();
        RenderSystem.m_157182_();
    }

    public record EllipsesData(Coordinate mouse, Coordinate topLeft, int maxItemsBeforeEllipses, int totalItemCount) {
    }
}

