/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.gui;

import ca.bradj.questown.gui.RenderContext;
import ca.bradj.questown.gui.Tab;
import ca.bradj.questown.mc.JEI;
import com.google.common.collect.ImmutableList;
import java.util.function.Consumer;
import mezz.jei.api.gui.drawable.IDrawableStatic;

public class Tabs {
    private final ImmutableList<Tab> tabs;
    private final IDrawableStatic tab;
    private final IDrawableStatic unTab;
    private final int X_OFFSET = 6;
    private final int Y_OFFSET = 3;

    public Tabs(ImmutableList<Tab> tabs) {
        this.tabs = tabs;
        this.tab = JEI.getTabSelected();
        this.unTab = JEI.getTabUnselected();
    }

    public boolean renderTooltip(int bgX, int bgY, int mouseX, int mouseY, Consumer<String> renderFn) {
        int tabTopY = bgY - this.unTab.getHeight();
        for (int i = 0; i < this.tabs.size(); ++i) {
            int tabLeftX = bgX + this.unTab.getWidth() * i;
            int tabRightX = tabLeftX + this.tab.getWidth();
            int tabBotY = tabTopY + this.unTab.getHeight();
            if (mouseX <= tabLeftX || mouseX >= tabRightX || mouseY <= tabTopY || mouseY >= tabBotY) continue;
            renderFn.accept(((Tab)this.tabs.get(i)).titleKey());
            return true;
        }
        return false;
    }

    public void draw(RenderContext rc, int bgX, int bgY) {
        for (int i = 0; i < this.tabs.size(); ++i) {
            IDrawableStatic tab = this.unTab;
            if (((Tab)this.tabs.get(i)).selected()) {
                tab = this.tab;
            }
            int tabX = bgX + tab.getWidth() * i;
            int tabY = bgY - tab.getHeight();
            tab.draw(rc.stack(), tabX + 6, tabY + 3);
            ((Tab)this.tabs.get(i)).renderFunc().accept((Object)rc, (Object)tabX, (Object)tabY);
        }
    }

    public void mouseClicked(int bgX, int bgY, double mouseX, double mouseY) {
        int tabsY = bgY - this.unTab.getHeight() + 3;
        for (int i = 0; i < this.tabs.size(); ++i) {
            int tabLeftX = bgX + this.unTab.getWidth() * i + 6;
            int tabRightX = tabLeftX + this.tab.getWidth();
            if (!(mouseX > (double)tabLeftX) || !(mouseX < (double)tabRightX) || !(mouseY > (double)tabsY) || !(mouseY < (double)(tabsY + this.unTab.getHeight()))) continue;
            ((Tab)this.tabs.get(i)).onClick().run();
            return;
        }
    }
}

