/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.gui;

import ca.bradj.questown.core.network.NetworkCompat;
import ca.bradj.questown.gui.Ingredients;
import ca.bradj.questown.jobs.JobID;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.NotNull;

public record UIJob(JobID jobId, ImmutableList<UUID> villagersWhoCanDoJob, ImmutableList<Ingredient> ingredients, ImmutableList<Ingredient> tools, ResourceLocation roomNameTranslationKey, ImmutableList<Ingredient> roomRecipe, ImmutableList<ItemStack> result) {
    public static UIJob fromNetwork(FriendlyByteBuf buf) {
        JobID jobId = NetworkCompat.fromNetworkJobID(buf);
        List vs = buf.m_236845_(FriendlyByteBuf::m_130259_);
        List in = buf.m_236845_(FriendlyByteBuf::m_130277_);
        List tl = buf.m_236845_(FriendlyByteBuf::m_130277_);
        ResourceLocation rrName = buf.m_130281_();
        List rr = buf.m_236845_(FriendlyByteBuf::m_130277_);
        List result = buf.m_236845_(FriendlyByteBuf::m_130267_);
        return UIJob.fromBufferData(jobId, in, tl, vs, rrName, rr, result);
    }

    public static void toNetwork(FriendlyByteBuf buf, UIJob uiJob) {
        NetworkCompat.toNetwork(buf, uiJob.jobId());
        List<String> ingIDs = uiJob.ingredients().stream().map(Ingredients::toString).toList();
        List<String> toolIDs = uiJob.tools().stream().map(Ingredients::toString).toList();
        List<String> roomRecipe = uiJob.roomRecipe().stream().map(Ingredients::toString).toList();
        buf.m_236828_(uiJob.villagersWhoCanDoJob(), FriendlyByteBuf::m_130077_);
        buf.m_236828_(ingIDs, FriendlyByteBuf::m_130070_);
        buf.m_236828_(toolIDs, FriendlyByteBuf::m_130070_);
        buf.m_130070_(uiJob.roomNameTranslationKey().toString());
        buf.m_236828_(roomRecipe, FriendlyByteBuf::m_130070_);
        buf.m_236828_(uiJob.result(), FriendlyByteBuf::m_130055_);
    }

    @NotNull
    private static UIJob fromBufferData(JobID jobId, List<String> in, List<String> tl, List<UUID> vs, ResourceLocation rrNameKey, List<String> rr, List<ItemStack> result) {
        ImmutableList.Builder bIngredients = ImmutableList.builder();
        ImmutableList.Builder bTools = ImmutableList.builder();
        ImmutableList.Builder bRoom = ImmutableList.builder();
        for (String s : in) {
            bIngredients.add((Object)Ingredients.fromString(s));
        }
        for (String s : tl) {
            bTools.add((Object)Ingredients.fromString(s));
        }
        for (String s : rr) {
            bRoom.add((Object)Ingredients.fromString(s));
        }
        return new UIJob(jobId, (ImmutableList<UUID>)ImmutableList.copyOf(vs), (ImmutableList<Ingredient>)bIngredients.build(), (ImmutableList<Ingredient>)bTools.build(), rrNameKey, (ImmutableList<Ingredient>)bRoom.build(), (ImmutableList<ItemStack>)ImmutableList.copyOf(result));
    }
}

