/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.gui;

import ca.bradj.questown.QT;
import ca.bradj.questown.core.init.MenuTypesInit;
import ca.bradj.questown.gui.AbstractQuestsContainer;
import ca.bradj.questown.gui.FlagTabsEmbedding;
import ca.bradj.questown.gui.UIQuest;
import ca.bradj.questown.gui.VillagerMenus;
import ca.bradj.questown.gui.VillagerTabs;
import ca.bradj.questown.gui.VillagerTabsEmbedding;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;

public class VillagerQuestsContainer
extends AbstractQuestsContainer
implements VillagerTabsEmbedding {
    private static final Collection<String> ENABLED_TABS = VillagerTabs.except("quests");
    private final UUID villagerUUID;
    private final boolean showBlockOfProgressTab;

    public VillagerQuestsContainer(int windowId, UUID villagerUUID, Collection<UIQuest> quests, BlockPos flagPos, boolean showBlockOfProgressTab) {
        super((MenuType)MenuTypesInit.VILLAGER_QUESTS.get(), windowId, quests, new FlagTabsEmbedding.FlagInfo(flagPos, showBlockOfProgressTab));
        this.villagerUUID = villagerUUID;
        this.showBlockOfProgressTab = showBlockOfProgressTab;
    }

    public static VillagerQuestsContainer ForClient(int windowId, Inventory inv, FriendlyByteBuf data) {
        try {
            VillagerMenus menus = VillagerMenus.fromNetwork(windowId, inv.f_35978_, data);
            return menus.questsMenu;
        }
        catch (Exception e) {
            QT.GUI_LOGGER.error("Failed to open villager quests container: {}", (Object)e.getMessage());
            throw e;
        }
    }

    public static void write(FriendlyByteBuf data, List<UIQuest> quests, BlockPos pos) {
        VillagerQuestsContainer.writeQuests(data, quests);
        VillagerQuestsContainer.writeFlagPos(data, pos);
    }

    @Override
    public Collection<String> getEnabledTabs() {
        return ENABLED_TABS;
    }

    @Override
    public BlockPos getFlagPos() {
        return this.flagInfo.flagPos();
    }

    @Override
    public UUID getVillagerUUID() {
        return this.villagerUUID;
    }

    @Override
    public boolean showBlockOfProgressTab() {
        return this.showBlockOfProgressTab;
    }
}

