/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.gui;

import ca.bradj.questown.core.init.MenuTypesInit;
import ca.bradj.questown.gui.UIQuest;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;

public class VisitorQuestsContainer
extends AbstractContainerMenu {
    private final Collection<UIQuest> quests;
    private VisitorContext ctx;

    public boolean isNewVisitor() {
        return this.ctx.finishedQuests == 0 && this.ctx.unfinishedQuests > 0;
    }

    public int finishedQuests() {
        return this.ctx.finishedQuests;
    }

    public int unfinishedQuests() {
        return this.ctx.unfinishedQuests;
    }

    public VisitorQuestsContainer(int windowId, Collection<UIQuest> quests, VisitorContext ctx) {
        super((MenuType)MenuTypesInit.VISITOR_QUESTS.get(), windowId);
        this.quests = quests;
        this.ctx = ctx;
    }

    public VisitorQuestsContainer(int windowId, Inventory inv, FriendlyByteBuf data) {
        this(windowId, VisitorQuestsContainer.readQuests(data), VisitorQuestsContainer.readVisitor(data));
    }

    private static Collection<UIQuest> readQuests(FriendlyByteBuf data) {
        int size = data.readInt();
        ArrayList r = (ArrayList)data.m_236838_(c -> new ArrayList(size), buf -> {
            ResourceLocation recipeID = buf.m_130281_();
            return new UIQuest.Serializer().fromNetwork(recipeID, (FriendlyByteBuf)buf);
        });
        r.sort(UIQuest::compareTo);
        return r;
    }

    private static VisitorContext readVisitor(FriendlyByteBuf data) {
        boolean isFirstVillager = data.readBoolean();
        int finishedQuests = data.readInt();
        int unfinishedQuests = data.readInt();
        return new VisitorContext(isFirstVillager, finishedQuests, unfinishedQuests);
    }

    public boolean m_6875_(Player p_38874_) {
        return true;
    }

    public Collection<UIQuest> GetQuests() {
        return this.quests;
    }

    public boolean isFirstVisitor() {
        return this.ctx.isFirstVillager;
    }

    public ItemStack m_7648_(Player p_38941_, int p_38942_) {
        return ItemStack.f_41583_;
    }

    public static class VisitorContext {
        public final boolean isFirstVillager;
        public final int finishedQuests;
        public final int unfinishedQuests;

        public VisitorContext(boolean isFirstVillager, int finishedQuests, int unfinishedQuests) {
            this.isFirstVillager = isFirstVillager;
            this.finishedQuests = finishedQuests;
            this.unfinishedQuests = unfinishedQuests;
        }
    }
}

