/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.gui;

import ca.bradj.questown.core.Coordinate;
import ca.bradj.questown.core.network.AddWorkFromUIMessage;
import ca.bradj.questown.core.network.OpenItemJobsMessage;
import ca.bradj.questown.core.network.QuestownNetwork;
import ca.bradj.questown.gui.Ingredients;
import ca.bradj.questown.gui.RenderUtil;
import ca.bradj.questown.jobs.JobID;
import ca.bradj.questown.jobs.Jobs;
import ca.bradj.questown.mc.Compat;
import ca.bradj.questown.mc.JEI;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import org.apache.logging.log4j.util.BiConsumer;

public class WorkRequestConfirmScreen
extends Screen {
    private static final int backgroundWidth = 176;
    private static final int backgroundHeight = 166;
    private static final int PAGE_PADDING = 10;
    private final JEI.NineNine background = JEI.getRecipeGuiBackground();
    private final ImmutableList<Map.Entry<JobID, ResourceLocation>> iconsForJobsWhichProduceResult;
    private final Ingredient itemRequested;
    private final Runnable requestWork;
    private final Runnable backToRequestedJobs;
    private final Runnable openJobsInfoScreen;
    private int pageTopY;
    private int mainItemIconY;
    private int mainItemTextY;
    private int mainItemTextY2;
    private int jobIconsY;
    private int pageLeftX;
    private int moreInfoButtonY;
    private int confirmTextY;
    private int confirmButtonY;

    public WorkRequestConfirmScreen(Ingredient requested, Map<JobID, ResourceLocation> iconsForJobsWhichProduceResult, BlockPos flagPos) {
        super((Component)Compat.translatable("menu.work_add_confirm.title", Compat.translatable(Ingredients.toString(requested))));
        this.itemRequested = requested;
        this.iconsForJobsWhichProduceResult = ImmutableList.copyOf(iconsForJobsWhichProduceResult.entrySet());
        this.requestWork = () -> this.send(flagPos, AddWorkFromUIMessage.Action.CONFIRMED);
        this.backToRequestedJobs = () -> this.send(flagPos, AddWorkFromUIMessage.Action.REJECTED);
        this.openJobsInfoScreen = () -> {
            OpenItemJobsMessage msg = new OpenItemJobsMessage(flagPos, this.itemRequested);
            QuestownNetwork.CHANNEL.sendToServer((Object)msg);
        };
    }

    private void send(BlockPos p, AddWorkFromUIMessage.Action action) {
        AddWorkFromUIMessage m = new AddWorkFromUIMessage(this.itemRequested, p, action);
        QuestownNetwork.CHANNEL.sendToServer((Object)m);
    }

    protected void m_7856_() {
        this.pageTopY = (this.f_96544_ - 166) / 2 + 10;
        this.pageLeftX = (this.f_96543_ - 176) / 2;
        Objects.requireNonNull(this.f_96547_);
        this.mainItemIconY = this.pageTopY + 2 * 9;
        double d = this.mainItemIconY;
        Objects.requireNonNull(this.f_96547_);
        this.mainItemTextY = (int)(d + 0.5 * 9.0);
        Objects.requireNonNull(this.f_96547_);
        int tallLine = (int)(9.0 * 1.5);
        this.mainItemTextY2 = this.mainItemTextY + tallLine;
        this.jobIconsY = this.mainItemTextY2 + tallLine;
        this.moreInfoButtonY = this.jobIconsY + 24;
        Objects.requireNonNull(this.f_96547_);
        int buttonHeight = 2 * 9 + 2;
        int buttonWidth = 156;
        this.m_142416_((GuiEventListener)new Button(this.pageLeftX + 10, this.moreInfoButtonY, buttonWidth, buttonHeight, Compat.translatable("menu.common.learn_more"), p_96776_ -> this.openJobsInfoScreen.run()));
        this.confirmTextY = this.pageTopY + 166 - 20 - buttonHeight - tallLine;
        this.confirmButtonY = this.confirmTextY + tallLine;
        this.m_142416_((GuiEventListener)new Button(this.pageLeftX + 10, this.confirmButtonY, (int)((float)buttonWidth / 2.0f), buttonHeight, Compat.translatable("menu.common.yes"), p_96776_ -> this.requestWork.run()));
        this.m_142416_((GuiEventListener)new Button((int)((float)(this.pageLeftX + 10) + (float)buttonWidth / 2.0f), this.confirmButtonY, (int)((float)buttonWidth / 2.0f), buttonHeight, Compat.translatable("menu.common.no"), p_96776_ -> this.backToRequestedJobs.run()));
    }

    public boolean m_7920_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 81) {
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public void m_6305_(PoseStack stack, int mouseX, int mouseY, float partialTicks) {
        this.m_93179_(stack, 0, 0, this.f_96543_, this.f_96544_, -1072689136, -804253680);
        this.m_7333_(stack);
        super.m_6305_(stack, mouseX, mouseY, partialTicks);
        int x = this.pageLeftX;
        int xRef = x += 10;
        Compat.drawDarkText(this.f_96547_, stack, this.f_96539_, x, this.pageTopY);
        Ingredients.render(this.f_96542_, this.itemRequested, x, this.mainItemIconY);
        Compat.drawDarkText(this.f_96547_, stack, (Component)Compat.translatable("menu.work_add_confirm.there_are_n_known_jobs", this.iconsForJobsWhichProduceResult.size()), x += 24, this.mainItemTextY);
        Component translatable = Compat.translatable("menu.work_add_confirm.which_produce_this_item");
        Compat.drawDarkText(this.f_96547_, stack, translatable, x, this.mainItemTextY2);
        this.renderJobIcons(stack, mouseX, mouseY, xRef, this.jobIconsY);
        Component confTxt = Compat.translatable("menu.work_add_confirm.confirm_text");
        Compat.drawDarkText(this.f_96547_, stack, confTxt, xRef, this.confirmTextY);
    }

    private void renderJobIcons(PoseStack stack, int mouseX, int mouseY, int xRef, int y) {
        RenderUtil.stripOfRequestableItems((ingr, coord) -> {
            Ingredient ing = Ingredients.fromRL((ResourceLocation)ingr.getValue());
            Ingredients.render(this.f_96542_, ing, coord.x(), coord.y());
        }, ingr -> Jobs.getComponentsForTooltip((JobID)ingr.getKey()), (BiConsumer<Component, Coordinate>)((BiConsumer)(text, coord) -> Compat.drawDarkText(this.f_96547_, stack, text, (int)coord.x(), (int)coord.y())), (BiConsumer<Coordinate, Coordinate>)((BiConsumer)(topLeft, botRight) -> RenderUtil.highlight(stack, topLeft, botRight)), this.iconsForJobsWhichProduceResult, new Coordinate(xRef, y), new Coordinate(xRef + 176 - 20, y), new Coordinate(mouseX, mouseY));
    }

    public void m_7333_(PoseStack poseStack) {
        int x = (this.f_96543_ - 176) / 2;
        int y = (this.f_96544_ - 166) / 2;
        this.background.draw(poseStack, x, y, 176, 166);
    }

    public boolean m_7043_() {
        return false;
    }

    public List<Rect2i> getExtraAreas() {
        int x = (this.f_96543_ - 176) / 2;
        int y = (this.f_96544_ - 166) / 2;
        return ImmutableList.of((Object)new Rect2i(x, y, 176, 166));
    }
}

