/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.gui;

import ca.bradj.questown.gui.AddWorkScreen;
import ca.bradj.questown.gui.Ingredients;
import ca.bradj.questown.gui.TownWorkContainer;
import ca.bradj.questown.gui.UIWork;
import ca.bradj.questown.mc.Compat;
import ca.bradj.questown.mc.JEI;
import ca.bradj.roomrecipes.core.space.Position;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.common.util.ImmutableRect2i;
import mezz.jei.common.util.MathUtil;
import mezz.jei.gui.elements.GuiIconButtonSmall;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public class WorkScreen
extends AbstractContainerScreen<TownWorkContainer> {
    private static final int backgroundWidth = 176;
    private static final int backgroundHeight = 166;
    private static final int borderPadding = 6;
    private static final int buttonWidth = 13;
    private static final int buttonHeight = 13;
    private static final int TEXT_COLOR = 0x404040;
    private static final int CARD_PADDING = 1;
    private static final int PAGE_PADDING = 10;
    private static final int CARD_WIDTH = 156;
    private static final int CARD_HEIGHT = 42;
    private static final int MAX_CARDS_PER_PAGE = 3;
    private final List<UIWork> work;
    private final JEI.NineNine background;
    private final JEI.NineNine cardBackground;
    private final GuiIconButtonSmall nextPage;
    private final GuiIconButtonSmall previousPage;
    private final GuiIconButtonSmall addMoreBtn;
    private final AddWorkScreen addWorkScreen;
    private int currentPage = 0;
    private Map<Position, Runnable> removes = new HashMap<Position, Runnable>();
    private List<Slot> slots = new ArrayList<Slot>();

    public WorkScreen(TownWorkContainer container, Inventory playerInv, Component title) {
        super((AbstractContainerMenu)container, playerInv, title);
        this.f_97726_ = 256;
        this.f_97727_ = 220;
        this.work = ImmutableList.copyOf(container.getWork());
        this.background = JEI.getRecipeGuiBackground();
        this.cardBackground = JEI.getRecipeBackground();
        IDrawableStatic plusIcon = JEI.getPlusIcon();
        int btnX = 157;
        IDrawableStatic arrowNext = JEI.getArrowNext();
        IDrawableStatic arrowPrevious = JEI.getArrowPrevious();
        this.nextPage = JEI.guiIconButtonSmall(0, 0, 13, 13, (IDrawable)arrowNext, b -> this.nextPage());
        this.previousPage = JEI.guiIconButtonSmall(0, 0, 13, 13, (IDrawable)arrowPrevious, b -> this.previousPage());
        this.addWorkScreen = new AddWorkScreen(((TownWorkContainer)this.f_97732_).addWorkContainer, playerInv, title);
        this.addMoreBtn = JEI.guiIconButtonSmall(btnX, 0, 13, 13, (IDrawable)plusIcon, b -> this.addMoreWork());
    }

    protected void m_7856_() {
        int y = (this.f_96544_ - 166) / 2;
        int pageStringY = y + 6;
        int x = (this.f_96543_ - 176) / 2;
        this.addMoreBtn.f_93620_ = x + 176 - 13 - 6;
        this.addMoreBtn.f_93621_ = pageStringY;
        this.m_142416_((GuiEventListener)this.addMoreBtn);
        this.previousPage.f_93620_ = x + 6;
        this.previousPage.f_93621_ = pageStringY;
        this.nextPage.f_93620_ = x + 176 - 26 - 6;
        this.nextPage.f_93621_ = pageStringY;
        this.m_142416_((GuiEventListener)this.previousPage);
        this.m_142416_((GuiEventListener)this.nextPage);
        if (((TownWorkContainer)this.m_6262_()).skipToAdd()) {
            this.addMoreWork();
        }
    }

    public boolean m_6050_(double scrollX, double scrollY, double scrollDelta) {
        double y;
        double x = JEI.getX();
        if (this.m_5953_(x, y = JEI.getY())) {
            if (scrollDelta < 0.0) {
                this.nextPage();
                return true;
            }
            if (scrollDelta > 0.0) {
                this.previousPage();
                return true;
            }
        }
        return super.m_6050_(scrollX, scrollY, scrollDelta);
    }

    public boolean m_7920_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 81) {
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(poseStack);
        super.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        int x = (this.f_96543_ - 176) / 2;
        int y = (this.f_96544_ - 166) / 2;
        int pageStringY = y + 10;
        this.renderPageNum(poseStack, x);
        y = pageStringY + 10;
        int startIndex = this.currentPage * 3;
        int endIndex = Math.min(startIndex + 3, this.work.size());
        x += 10;
        y += 10;
        ImmutableList.Builder b = ImmutableList.builder();
        for (int i = startIndex; i < endIndex; ++i) {
            int row = i - startIndex;
            int cardY = y + row * 43;
            UIWork jobPosting = this.work.get(i);
            if (jobPosting == null) continue;
            this.cardBackground.draw(poseStack, x, cardY, 156, 42);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int iconY = cardY + 42 - 24;
            ImmutableList<Slot> slotz = this.renderJobCardIcons(poseStack, jobPosting, x, iconY, mouseX, mouseY);
            b.addAll(slotz);
            int idX = x + 10;
            int idY = iconY - 10;
            this.f_96547_.m_92889_(poseStack, Compat.translatable("job_board.default_name"), (float)idX, (float)idY, 0x404040);
            int removeX = idX + 156 - 20 - 13;
            this.f_96547_.m_92763_(poseStack, Compat.literal("x"), (float)(removeX + 6 - 1), (float)(iconY + 6 - 1), 0xFFFFFF);
            this.highlightAndTooltip(poseStack, mouseX, mouseY, removeX, iconY, Compat.translatable("job_board.remove_work"));
            this.removes.put(new Position(removeX, iconY), () -> ((TownWorkContainer)this.f_97732_).sendRemoveRequest(jobPosting));
        }
        this.slots.clear();
        this.slots.addAll((Collection<Slot>)b.build());
        this.addMoreBtn.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        this.previousPage.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        this.nextPage.m_6305_(poseStack, mouseX, mouseY, partialTicks);
    }

    private ImmutableList<Slot> renderJobCardIcons(PoseStack poseStack, UIWork recipe, int x, int y, int mouseX, int mouseY) {
        Inventory dummyInv = new Inventory(null);
        Ingredient ing = recipe.getResultWanted().asIngredient();
        ImmutableList.Builder b = ImmutableList.builder();
        int iconX = x + 8;
        ItemStack itemStack = Ingredients.render(this.f_96542_, ing, iconX, y);
        if (itemStack != null) {
            this.highlightAndTooltip(poseStack, mouseX, mouseY, iconX, y, itemStack.m_41720_().m_7626_(itemStack));
            Slot element = new Slot((Container)dummyInv, 0, iconX, y + 1);
            element.m_5852_(itemStack);
            b.add((Object)element);
        }
        return b.build();
    }

    private void highlightAndTooltip(PoseStack poseStack, int mouseX, int mouseY, int iconX, int iconY, Component tooltipText) {
        if (mouseX >= iconX && mouseY >= iconY && mouseX < iconX + 16 && mouseY < iconY + 17) {
            WorkScreen.m_93172_((PoseStack)poseStack, (int)iconX, (int)(iconY + 1), (int)(iconX + 16), (int)(iconY + 17), (int)-2130706433);
            this.m_96602_(poseStack, tooltipText, mouseX, mouseY);
        }
    }

    public boolean m_6375_(double x, double y, int p_97750_) {
        for (Map.Entry<Position, Runnable> p : this.removes.entrySet()) {
            int buttonX = p.getKey().x;
            int buttonY = p.getKey().z;
            if (!(x >= (double)buttonX) || !(y >= (double)buttonY) || !(x < (double)(buttonX + 16)) || !(y < (double)(buttonY + 17))) continue;
            p.getValue().run();
            return true;
        }
        return super.m_6375_(x, y, p_97750_);
    }

    private void renderPageNum(PoseStack poseStack, int x) {
        WorkScreen.m_93172_((PoseStack)poseStack, (int)(x + 6 + 13), (int)this.nextPage.f_93621_, (int)(x + 176 - 6 - 13), (int)(this.nextPage.f_93621_ + 13), (int)0x30000000);
        int totalPages = (int)Math.ceil((double)this.work.size() / 3.0);
        String pageString = "Page " + (this.currentPage + 1) + " / " + totalPages;
        ImmutableRect2i pageArea = MathUtil.union((ImmutableRect2i)this.previousPage.getArea(), (ImmutableRect2i)this.nextPage.getArea());
        ImmutableRect2i textArea = MathUtil.centerTextArea((ImmutableRect2i)pageArea, (Font)this.f_96547_, (String)pageString);
        Compat.drawLightText(this.f_96547_, poseStack, pageString, textArea.getX(), textArea.getY());
    }

    protected void m_7286_(PoseStack poseStack, float partialTicks, int mouseX, int mouseY) {
        int x = (this.f_96543_ - 176) / 2;
        int y = (this.f_96544_ - 166) / 2;
        this.background.draw(poseStack, x, y, 176, 166);
    }

    private void renderSlot(PoseStack poseStack, Slot slot, int mouseX, int mouseY, float partialTicks) {
        ItemStack stack = slot.m_7993_();
        if (!stack.m_41619_()) {
            this.f_96541_.m_91291_().m_115123_(stack, slot.f_40220_, slot.f_40221_);
            this.f_96541_.m_91291_().m_115174_(this.f_96547_, stack, slot.f_40220_, slot.f_40221_, "");
        }
    }

    private void nextPage() {
        int totalPages = (int)Math.ceil((double)this.work.size() / 3.0);
        if (this.currentPage < totalPages - 1) {
            ++this.currentPage;
        }
    }

    private void previousPage() {
        if (this.currentPage > 0) {
            --this.currentPage;
        }
    }

    private void addMoreWork() {
        this.f_96541_.m_91152_((Screen)this.addWorkScreen);
    }

    public boolean m_7043_() {
        return false;
    }

    public List<Rect2i> getExtraAreas() {
        int x = (this.f_96543_ - 176) / 2;
        int y = (this.f_96544_ - 166) / 2;
        return ImmutableList.of((Object)new Rect2i(x, y, 176, 166));
    }

    public ItemStack getHoveredIngredient(int mouseX, int mouseY) {
        Predicate<Slot> slotPredicate = s -> mouseX >= s.f_40220_ && mouseX <= s.f_40220_ + 16 && mouseY >= s.f_40221_ + 1 && mouseY <= s.f_40221_ + 17;
        Stream<Slot> matches = this.slots.stream().filter(slotPredicate);
        Optional<Slot> found = matches.findAny();
        return found.map(Slot::m_7993_).orElse(ItemStack.f_41583_);
    }

    public boolean m_5953_(double mouseX, double mouseY) {
        return true;
    }
}

