/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.gui.villager.advancements;

import ca.bradj.questown.jobs.JobID;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.apache.commons.lang3.function.TriFunction;
import org.jetbrains.annotations.NotNull;

public class JobRelationship
implements Iterable<JobRelationship> {
    @Nullable
    public final JobID parentId;
    private final JobID id;
    private final HashSet<JobRelationship> jobs;

    JobRelationship(@Nullable JobID parentId, @Nullable JobID id, Collection<JobRelationship> jobs) {
        this.parentId = parentId;
        this.id = id;
        this.jobs = new HashSet<JobRelationship>(jobs);
    }

    public <X> void forEach(X parentWidget, TriFunction<JobRelationship, ContextualPosition, X, X> fn, Predicate<JobRelationship> include) {
        int i = 0;
        int leafs = this.countLeafNodes(include);
        List<JobRelationship> jobz = this.jobs.stream().filter(include).toList();
        for (JobRelationship j : jobz) {
            Object newWidget = fn.apply((Object)j, (Object)new ContextualPosition(i, jobz.size(), leafs), parentWidget);
            j.forEach(newWidget, fn, include);
            ++i;
        }
    }

    public JobID id() {
        return this.id;
    }

    public void addChildLeaf(JobID _id) {
        if (this.jobs.stream().anyMatch(v -> _id.equals(v.id))) {
            return;
        }
        this.jobs.add(new JobRelationship(this.id, _id, (Collection<JobRelationship>)ImmutableList.of()));
    }

    @Override
    @NotNull
    public Iterator<JobRelationship> iterator() {
        return this.jobs.iterator();
    }

    public JobRelationship branch(String s) {
        for (JobRelationship job : this.jobs) {
            if (job.id == null || !job.id.rootId().equals(s)) continue;
            return job;
        }
        return this;
    }

    public JobRelationship filtered(Predicate<JobID> check) {
        List<JobRelationship> jobz = this.jobs.stream().filter(v -> check.test(v.id)).map(v -> v.filtered(check)).toList();
        return new JobRelationship(this.parentId, this.id, jobz);
    }

    public int countLeafNodes(Predicate<JobRelationship> include) {
        List<JobRelationship> jobz = this.jobs.stream().filter(include).toList();
        if (jobz.isEmpty()) {
            return 1;
        }
        return jobz.stream().map(z -> z.countLeafNodes(include)).reduce(Integer::sum).orElse(0);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JobRelationship that = (JobRelationship)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.jobs, that.jobs);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.jobs);
    }

    public record ContextualPosition(int pos, int sizeOfLevel, int relevantLeafNodes) {
    }
}

