/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.gui.villager.advancements;

import ca.bradj.questown.gui.villager.advancements.JobRelationship;
import ca.bradj.questown.jobs.JobID;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;

public class VillagerAdvancements {
    private static final Map<JobID, ResourceLocation> icons = new HashMap<JobID, ResourceLocation>();
    private static final JobRelationship all = new JobRelationship(null, null, (Collection<JobRelationship>)ImmutableList.of());
    private static List<Supplier<JobID>> unregistered = new ArrayList<Supplier<JobID>>();

    public static JobRelationship all() {
        return all;
    }

    public static void registerOnClientSide(JobID id, JobID parentID) {
        Supplier<JobID> lambda = () -> VillagerAdvancements.addToParentOrReturn(id, parentID, all);
        JobID notRegistered = lambda.get();
        if (notRegistered != null) {
            unregistered.add(lambda);
            return;
        }
        if (unregistered.isEmpty()) {
            return;
        }
        ImmutableList.Builder b = ImmutableList.builder();
        for (Supplier<JobID> jobIDSupplier : unregistered) {
            JobID stillUnregged = jobIDSupplier.get();
            if (stillUnregged == null) continue;
            b.add(jobIDSupplier);
        }
        unregistered.clear();
        unregistered.addAll((Collection<Supplier<JobID>>)b.build());
    }

    private static JobID addToParentOrReturn(JobID id, JobID parentID, JobRelationship rels) {
        if (rels.id() == null && parentID == null) {
            rels.addChildLeaf(id);
            return null;
        }
        if (rels.id() != null && rels.id().equals(parentID)) {
            rels.addChildLeaf(id);
            return null;
        }
        for (JobRelationship rel : rels) {
            JobID v = VillagerAdvancements.addToParentOrReturn(id, parentID, rel);
            if (v != null) continue;
            return null;
        }
        return id;
    }

    public static void registerIcons(Map<JobID, ResourceLocation> in) {
        icons.clear();
        icons.putAll(in);
    }

    public static ItemStack getIcon(JobID prerequisite) {
        return ((Item)ForgeRegistries.ITEMS.getValue(icons.get(prerequisite))).m_7968_();
    }
}

