/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.gui.villager.advancements;

import ca.bradj.questown.gui.villager.advancements.JobRelationship;
import ca.bradj.questown.gui.villager.advancements.VillagerAdvancements;
import ca.bradj.questown.gui.villager.advancements.VillagerAdvancementsScreen;
import ca.bradj.questown.gui.villager.advancements.VillagerAdvancementsWidget;
import ca.bradj.questown.jobs.JobID;
import ca.bradj.questown.mc.Compat;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.AtomicDouble;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VillagerAdvancementsContent
extends GuiComponent {
    private final Minecraft minecraft;
    private final VillagerAdvancementsScreen screen;
    private final DisplayInfo display;
    private final ItemStack icon;
    private final Component title;
    private final VillagerAdvancementsWidget root;
    private final Map<JobID, VillagerAdvancementsWidget> widgets;
    private final Collection<JobID> unlockedJobs;
    private double scrollX;
    private double scrollY;
    private int minX = Integer.MAX_VALUE;
    private int minY = Integer.MAX_VALUE;
    private int maxX = Integer.MIN_VALUE;
    private int maxY = Integer.MIN_VALUE;
    private float fade;
    private boolean initializedToCenter;
    @javax.annotation.Nullable
    private VillagerAdvancementsWidget hoveredWidget;

    public VillagerAdvancementsContent(Minecraft minecraft, VillagerAdvancementsScreen screen, DisplayInfo p_97150_, @javax.annotation.Nullable JobID currentJob, Collection<JobID> unlockedJobs, Collection<JobID> unlockableJobs, JobRelationship allJobs) {
        this.unlockedJobs = unlockedJobs;
        this.widgets = Maps.newLinkedHashMap();
        this.minX = Integer.MAX_VALUE;
        this.minY = Integer.MAX_VALUE;
        this.maxX = Integer.MIN_VALUE;
        this.maxY = Integer.MIN_VALUE;
        this.minecraft = minecraft;
        this.screen = screen;
        this.display = p_97150_;
        this.icon = p_97150_.m_14990_();
        this.title = p_97150_.m_14977_();
        if (!Minecraft.m_91087_().f_91074_.m_7500_()) {
            allJobs = allJobs.filtered(v -> unlockedJobs.contains(v) || unlockableJobs.contains(v));
        }
        Map<JobID, Float> ys = this.preComputeLayout(allJobs);
        Float minnY = ys.values().stream().min(Float::compare).orElse(Float.valueOf(0.0f));
        p_97150_.m_14978_(p_97150_.m_14993_(), p_97150_.m_14994_() - minnY.floatValue());
        this.root = this.makeRoot(minecraft, p_97150_, currentJob, allJobs);
        allJobs.forEach(this.root, (adv, p, parentWidget) -> {
            DisplayInfo di = new DisplayInfo(VillagerAdvancements.getIcon(adv.id()), Compat.translatable(adv.id().jobId()), Compat.literal(""), this.display.m_14991_(), this.display.m_14992_(), false, false, false);
            di.m_14978_(parentWidget.display.m_14993_() + 1.0f, ((Float)ys.get(adv.id())).floatValue() - minnY.floatValue());
            VillagerAdvancementsWidget newWidget = new VillagerAdvancementsWidget(this, minecraft, di, adv.id(), currentJob != null && currentJob.equals(adv.id()), unlockedJobs.contains(adv.id()), parentWidget.id, unlockableJobs.contains(adv.id()));
            this.addWidget(newWidget, adv.id());
            return newWidget;
        }, v -> unlockedJobs.contains(v.id()) || unlockedJobs.contains(v.parentId));
    }

    @NotNull
    private VillagerAdvancementsWidget makeRoot(Minecraft minecraft, DisplayInfo p_97150_, @Nullable JobID currentJob, JobRelationship allJobs) {
        if (!allJobs.equals(VillagerAdvancements.all())) {
            DisplayInfo di = new DisplayInfo(VillagerAdvancements.getIcon(allJobs.id()), Compat.translatable(allJobs.id().jobId()), Compat.literal(""), this.display.m_14991_(), this.display.m_14992_(), false, false, false);
            di.m_14978_(p_97150_.m_14993_() + 1.0f, p_97150_.m_14994_());
            VillagerAdvancementsWidget vaw = new VillagerAdvancementsWidget(this, minecraft, di, allJobs.id(), currentJob.equals(allJobs.id()), true, null, true);
            this.addWidget(vaw, allJobs.id());
            return vaw;
        }
        JobID unemployed = new JobID("unemployed", "unemployed");
        VillagerAdvancementsWidget vaw = new VillagerAdvancementsWidget(this, minecraft, p_97150_, unemployed, currentJob == null, true, null, true);
        this.addWidget(vaw, unemployed);
        return vaw;
    }

    public boolean isLocked(JobID id) {
        return !this.unlockedJobs.contains(id);
    }

    @NotNull
    private Map<JobID, Float> preComputeLayout(JobRelationship advancements) {
        HashMap<JobID, Float> map = new HashMap<JobID, Float>();
        Predicate<JobRelationship> jp = v -> this.unlockedJobs.contains(v.id()) || this.unlockedJobs.contains(v.parentId);
        advancements.forEach(new Precompute(new AtomicDouble(0.0), 0.0f), (adv, p, pre) -> {
            int totalHeight = p.relevantLeafNodes();
            float radius = (float)totalHeight / 2.0f;
            float ownSize = adv.countLeafNodes(jp);
            AtomicDouble spaceUsed = pre.spaceUsedBySiblings();
            float y = pre.parentY() - radius + spaceUsed.floatValue() + ownSize / 2.0f;
            spaceUsed.set((double)(spaceUsed.floatValue() + ownSize));
            map.put(adv.id(), Float.valueOf(y));
            return new Precompute(new AtomicDouble(0.0), y);
        }, jp);
        return map;
    }

    public Component getTitle() {
        return this.title;
    }

    public DisplayInfo getDisplay() {
        return this.display;
    }

    public void drawContents(PoseStack p_97164_) {
        if (!this.initializedToCenter) {
            this.scrollX = 117 - (this.maxX + this.minX) / 2;
            this.scrollY = 56 - (this.maxY + this.minY) / 2;
            this.initializedToCenter = true;
        }
        p_97164_.m_85836_();
        p_97164_.m_85837_(0.0, 0.0, 950.0);
        RenderSystem.m_69482_();
        RenderSystem.m_69444_((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        VillagerAdvancementsContent.m_93172_((PoseStack)p_97164_, (int)4680, (int)2260, (int)-4680, (int)-2260, (int)-16777216);
        RenderSystem.m_69444_((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        p_97164_.m_85837_(0.0, 0.0, -950.0);
        RenderSystem.m_69456_((int)518);
        VillagerAdvancementsContent.m_93172_((PoseStack)p_97164_, (int)234, (int)113, (int)0, (int)0, (int)-16777216);
        RenderSystem.m_69456_((int)515);
        ResourceLocation resourcelocation = this.display.m_14991_();
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        if (resourcelocation != null) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)resourcelocation);
        } else {
            RenderSystem.m_157456_((int)0, (ResourceLocation)TextureManager.f_118466_);
        }
        int i = Mth.m_14107_((double)this.scrollX);
        int j = Mth.m_14107_((double)this.scrollY);
        int k = i % 16;
        int l = j % 16;
        for (int i1 = -1; i1 <= 15; ++i1) {
            for (int j1 = -1; j1 <= 8; ++j1) {
                VillagerAdvancementsContent.m_93133_((PoseStack)p_97164_, (int)(k + 16 * i1), (int)(l + 16 * j1), (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
            }
        }
        this.root.drawConnectivity(p_97164_, i, j, true);
        this.root.drawConnectivity(p_97164_, i, j, false);
        this.root.draw(p_97164_, i, j);
        RenderSystem.m_69456_((int)518);
        p_97164_.m_85837_(0.0, 0.0, -950.0);
        RenderSystem.m_69444_((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        VillagerAdvancementsContent.m_93172_((PoseStack)p_97164_, (int)4680, (int)2260, (int)-4680, (int)-2260, (int)-16777216);
        RenderSystem.m_69444_((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.m_69456_((int)515);
        p_97164_.m_85849_();
    }

    public void drawTooltips(PoseStack p_97184_, int p_97185_, int p_97186_, int p_97187_, int p_97188_) {
        p_97184_.m_85836_();
        p_97184_.m_85837_(0.0, 0.0, -200.0);
        VillagerAdvancementsContent.m_93172_((PoseStack)p_97184_, (int)0, (int)0, (int)234, (int)113, (int)(Mth.m_14143_((float)(this.fade * 255.0f)) << 24));
        boolean flag = false;
        int i = Mth.m_14107_((double)this.scrollX);
        int j = Mth.m_14107_((double)this.scrollY);
        if (p_97185_ > 0 && p_97185_ < 234 && p_97186_ > 0 && p_97186_ < 113) {
            Iterator<VillagerAdvancementsWidget> var9 = this.widgets.values().iterator();
            boolean found = false;
            while (var9.hasNext()) {
                VillagerAdvancementsWidget advancementwidget = var9.next();
                if (!advancementwidget.isMouseOver(i, j, p_97185_, p_97186_) || !this.minecraft.f_91074_.m_7500_() && !this.unlockedJobs.contains(advancementwidget.id) && !this.unlockedJobs.contains(advancementwidget.parentId)) continue;
                flag = true;
                advancementwidget.drawHover(p_97184_, i, j, this.fade, p_97187_, p_97188_);
                this.hoveredWidget = advancementwidget;
                found = true;
                break;
            }
            if (!found) {
                this.hoveredWidget = null;
            }
        }
        p_97184_.m_85849_();
        this.fade = flag ? Mth.m_14036_((float)(this.fade + 0.02f), (float)0.0f, (float)0.3f) : Mth.m_14036_((float)(this.fade - 0.04f), (float)0.0f, (float)1.0f);
    }

    public void scroll(double p_97152_, double p_97153_) {
        if (this.maxX - this.minX > 234) {
            this.scrollX = Mth.m_14008_((double)(this.scrollX + p_97152_), (double)(-(this.maxX - 234)), (double)0.0);
        }
        if (this.maxY - this.minY > 113) {
            this.scrollY = Mth.m_14008_((double)(this.scrollY + p_97153_), (double)(-(this.maxY - 113)), (double)0.0);
        }
    }

    private void addWidget(VillagerAdvancementsWidget p_97176_, JobID advancement) {
        this.widgets.put(advancement, p_97176_);
        int i = p_97176_.getX();
        int j = i + 28;
        int k = p_97176_.getY();
        int l = k + 27;
        this.minX = Math.min(this.minX, i);
        this.maxX = Math.max(this.maxX, j);
        this.minY = Math.min(this.minY, k);
        this.maxY = Math.max(this.maxY, l);
        for (VillagerAdvancementsWidget advancementwidget : this.widgets.values()) {
            advancementwidget.attachToParent();
        }
    }

    @javax.annotation.Nullable
    public VillagerAdvancementsWidget getWidget(JobID p_97181_) {
        return this.widgets.get(p_97181_);
    }

    public VillagerAdvancementsScreen getScreen() {
        return this.screen;
    }

    @javax.annotation.Nullable
    public JobID getClickJob(double mouseX, double mouseY) {
        if (this.hoveredWidget == null) {
            return null;
        }
        return this.hoveredWidget.id;
    }

    private record Precompute(AtomicDouble spaceUsedBySiblings, float parentY) {
    }
}

