/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.integration.minecraft;

import ca.bradj.questown.integration.minecraft.MCContainerInterface;
import ca.bradj.questown.integration.minecraft.MCTownItem;
import ca.bradj.questown.jobs.leaver.RankBoost;
import ca.bradj.questown.mc.Util;
import java.util.ArrayList;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class MCContainer
implements MCContainerInterface {
    private final Container container;

    public MCContainer(@NotNull Container container) {
        this.container = container;
    }

    @Override
    public int size() {
        return this.container.m_6643_();
    }

    @Override
    public MCTownItem getItem(int i) {
        ItemStack cItem = this.container.m_8020_(i);
        return MCTownItem.fromMCItemStack(cItem);
    }

    @Override
    public MCTownItem removeItem(int index) {
        return MCTownItem.fromMCItemStack(this.container.m_7407_(index, 1));
    }

    @Override
    public boolean setItem(int i, MCTownItem item) {
        this.container.m_6836_(i, item.toMCItemStack());
        return true;
    }

    @Override
    public boolean isFull() {
        for (int i = 0; i < this.container.m_6643_(); ++i) {
            if (!this.container.m_8020_(i).m_41619_()) continue;
            return false;
        }
        return true;
    }

    @Override
    public String toShortString() {
        return this.toShortString(true);
    }

    @Override
    public String toShortString(boolean includeAir) {
        return MCContainer.toShortString(this.container, includeAir);
    }

    private static String toShortString(Container container, boolean includeAir) {
        return Util.toShortString(container.m_6643_(), arg_0 -> ((Container)container).m_8020_(arg_0), includeAir);
    }

    @Override
    public boolean canAcceptIfSpaceAllows(MCTownItem item) {
        return true;
    }

    @Override
    public RankBoost getItemAcceptanceRankBoost() {
        return RankBoost.SAME_AS_VANILLA_CHEST;
    }

    public String toString() {
        ArrayList<String> items = new ArrayList<String>();
        for (int i = 0; i < this.container.m_6643_(); ++i) {
            items.add(this.getItem(i).getShortName());
        }
        return "MCContainer{container.items=" + String.valueOf(items) + "}";
    }
}

