/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.integration.minecraft;

import ca.bradj.questown.core.init.TagsInit;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class MCTownItem
implements ca.bradj.questown.jobs.Item<MCTownItem> {
    private final int quantity;
    private final Item item;
    private final CompoundTag nbt;

    public static MCTownItem fromMCItemStack(ItemStack i) {
        return new MCTownItem(i.m_41720_(), i.m_41613_(), i.serializeNBT());
    }

    public static MCTownItem of(CompoundTag tag) {
        CompoundTag nbt = tag.m_128469_("item");
        ItemStack stack = ItemStack.m_41712_((CompoundTag)nbt);
        return new MCTownItem(stack.m_41720_(), stack.m_41613_(), nbt);
    }

    public MCTownItem(Item item, int quantity, CompoundTag nbt) {
        this.quantity = quantity;
        this.item = item;
        this.nbt = nbt;
    }

    public MCTownItem copy() {
        return new MCTownItem(this.item, this.quantity, this.nbt.m_6426_());
    }

    @Override
    public boolean isEmpty() {
        return Items.f_41852_.equals(this.item);
    }

    @Override
    public boolean isFood() {
        return Ingredient.m_204132_(TagsInit.Items.VILLAGER_FOOD).test(new ItemStack((ItemLike)this.item));
    }

    public Item get() {
        return this.item;
    }

    public String toString() {
        return "MCTownItem{quantity=" + this.quantity + ", item=" + String.valueOf(this.item) + ", nbt=" + String.valueOf(this.nbt) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MCTownItem that = (MCTownItem)o;
        if (this.isEmpty() && that.isEmpty()) {
            return true;
        }
        return this.isSameIgnoringNBT(that) && Objects.equals(this.nbt, that.nbt);
    }

    public boolean isSameIgnoringNBT(MCTownItem that) {
        return this.quantity == that.quantity && Objects.equals(this.item, that.item);
    }

    public int hashCode() {
        return Objects.hash(this.quantity, this.item, this.nbt);
    }

    public static MCTownItem Air() {
        return new MCTownItem(Items.f_41852_, 1, new CompoundTag());
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("item", (Tag)this.nbt);
        return tag;
    }

    @Override
    public MCTownItem shrink() {
        if (this.quantity == 1) {
            return MCTownItem.Air();
        }
        ItemStack stack = this.toQTItemStack();
        stack.m_41774_(1);
        return new MCTownItem(stack.m_41720_(), stack.m_41613_(), stack.serializeNBT());
    }

    @Override
    public MCTownItem unit() {
        return this.withQuantity(1);
    }

    public MCTownItem withQuantity(int qy) {
        ItemStack stack = this.toQTItemStack();
        stack.m_41764_(qy);
        return new MCTownItem(stack.m_41720_(), qy, stack.serializeNBT());
    }

    @Override
    public int quantity() {
        return this.quantity;
    }

    @Override
    public String getShortName() {
        String name = "[unknown]";
        ResourceLocation registryName = ForgeRegistries.ITEMS.getKey((Object)this.get());
        if (registryName != null) {
            name = registryName.toString();
        }
        if (this.quantity > 1) {
            name = String.format("%sx%s", this.quantity, name);
        }
        return name;
    }

    public ItemStack toQTItemStack() {
        return this.toItemStack(StackPolicy.KEEP_QT_NBT);
    }

    public ItemStack toMCItemStack() {
        return this.toItemStack(StackPolicy.STRIP_QT_NBT);
    }

    private ItemStack toItemStack(StackPolicy preserveQTNBT) {
        ItemStack newOne = ItemStack.m_41712_((CompoundTag)this.nbt);
        if (preserveQTNBT == StackPolicy.KEEP_QT_NBT) {
            return newOne;
        }
        CompoundTag stripped = this.stripQTNBT(newOne.m_41784_());
        if (stripped.m_128456_()) {
            newOne.m_41751_(null);
        } else {
            newOne.m_41751_(stripped);
        }
        return newOne;
    }

    public boolean hasEmptyNBT() {
        CompoundTag copy = this.stripQTNBT(this.nbt);
        return copy.m_128456_();
    }

    @NotNull
    private CompoundTag stripQTNBT(CompoundTag in) {
        CompoundTag copy = in.m_6426_();
        if (copy.m_128441_("id")) {
            copy.m_128473_("id");
        }
        if (copy.m_128441_("Count")) {
            copy.m_128473_("Count");
        }
        if (copy.m_128441_("tag") && copy.m_128469_("tag").m_128456_()) {
            copy.m_128473_("tag");
        }
        return copy;
    }

    public void setNBT(Consumer<CompoundTag> adder) {
        adder.accept(this.nbt.m_128469_("tag"));
    }

    public CompoundTag getItemNBT() {
        return this.nbt.m_6426_().m_128469_("tag");
    }

    public static enum StackPolicy {
        KEEP_QT_NBT,
        STRIP_QT_NBT;

    }
}

