/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.integration.minecraft;

import ca.bradj.questown.QT;
import ca.bradj.questown.Questown;
import ca.bradj.questown.integration.minecraft.MCContainer;
import ca.bradj.questown.integration.minecraft.MCHeldItem;
import ca.bradj.questown.integration.minecraft.MCTownItem;
import ca.bradj.questown.integration.minecraft.MCTownState;
import ca.bradj.questown.jobs.ImmutableSnapshot;
import ca.bradj.questown.jobs.ServerJobsRegistry;
import ca.bradj.questown.jobs.leaver.ContainerTarget;
import ca.bradj.questown.mc.Util;
import ca.bradj.questown.town.TownContainers;
import ca.bradj.questown.town.TownState;
import ca.bradj.questown.town.workstatus.State;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TownStateSerializer {
    public static final TownStateSerializer INSTANCE = new TownStateSerializer();

    public CompoundTag store(MCTownState state) {
        CompoundTag tag = new CompoundTag();
        tag.m_128356_("world_time_at_sleep", state.worldTimeAtSleep);
        ListTag containers = new ListTag();
        for (ContainerTarget c : state.containers) {
            CompoundTag cTag = new CompoundTag();
            cTag.m_128405_("x", c.getPosition().x);
            cTag.m_128405_("y", c.getYPosition());
            cTag.m_128405_("z", c.getPosition().z);
            ListTag items = new ListTag();
            for (MCTownItem i : c.getItems()) {
                items.add((Object)i.serializeNBT());
            }
            cTag.m_128365_("items", (Tag)items);
            containers.add((Object)cTag);
        }
        tag.m_128365_("containers", (Tag)containers);
        ListTag villagers = new ListTag();
        for (TownState.VillagerData e : state.villagers) {
            CompoundTag vTag = new CompoundTag();
            vTag.m_128347_("x", e.xPosition);
            vTag.m_128347_("y", e.yPosition);
            vTag.m_128347_("z", e.zPosition);
            vTag.m_128359_("journal_status", e.journal.statusStringValue());
            ListTag journalItems = new ListTag();
            if (e.journal.items().size() != e.getCapacity()) {
                throw new IllegalStateException("Journal items do not match capacity");
            }
            for (MCHeldItem item : e.journal.items()) {
                journalItems.add((Object)item.serializeNBT());
            }
            vTag.m_128365_("journal_items", (Tag)journalItems);
            vTag.m_128362_("UUID", e.uuid);
            vTag.m_128359_("job", ServerJobsRegistry.getStringValue(e.journal.jobId()));
            villagers.add((Object)vTag);
        }
        tag.m_128365_("villagers", (Tag)villagers);
        return tag;
    }

    public MCTownState load(CompoundTag tag, ServerLevel level, GatesGetter gg) {
        long worldTimeAtSleep = tag.m_128454_("world_time_at_sleep");
        ImmutableList<ContainerTarget<MCContainer, MCTownItem>> containers = this.loadContainers(tag, level);
        ImmutableList<TownState.VillagerData<MCHeldItem>> villagers = TownStateSerializer.loadVillagers(tag);
        @NotNull ImmutableMap workStates = ImmutableMap.of();
        @NotNull ImmutableMap workTimers = ImmutableMap.of();
        @NotNull ImmutableList knowledge = ImmutableList.of();
        @NotNull ImmutableMap bops = ImmutableMap.of();
        ImmutableList<BlockPos> gates = this.loadGates(tag, gg);
        return new MCTownState((List<TownState.VillagerData<MCHeldItem>>)villagers, (List<ContainerTarget<MCContainer, MCTownItem>>)containers, (ImmutableMap<BlockPos, State>)workStates, (ImmutableMap<BlockPos, Integer>)workTimers, (List<BlockPos>)gates, (ImmutableList<MCHeldItem>)knowledge, (ImmutableMap<UUID, Boolean>)bops, worldTimeAtSleep);
    }

    private ImmutableList<BlockPos> loadGates(CompoundTag tag, GatesGetter gg) {
        ImmutableList.Builder b = ImmutableList.builder();
        ListTag positions = tag.m_128437_("gate_positions", 10);
        for (Tag pTag : positions) {
            int z;
            int y;
            CompoundTag pcTag = (CompoundTag)pTag;
            int x = pcTag.m_128451_("x");
            BlockPos bp = new BlockPos(x, y = pcTag.m_128451_("y"), z = pcTag.m_128451_("z"));
            if (!gg.isGateValid(bp)) {
                Questown.LOGGER.error("Gate was in town state, but not found in world. This is a bug. {}", (Object)bp);
                continue;
            }
            b.add((Object)bp);
        }
        return b.build();
    }

    @NotNull
    public static ImmutableList<TownState.VillagerData<MCHeldItem>> loadVillagers(CompoundTag tag) {
        ImmutableList.Builder b = ImmutableList.builder();
        ListTag villagers = tag.m_128437_("villagers", 10);
        for (Tag vTag : villagers) {
            CompoundTag vcTag = (CompoundTag)vTag;
            int x = vcTag.m_128451_("x");
            int y = vcTag.m_128451_("y");
            int z = vcTag.m_128451_("z");
            ListTag items = vcTag.m_128437_("journal_items", 10);
            ImmutableList.Builder iB = ImmutableList.builder();
            for (Tag itemTag : items) {
                CompoundTag itemCTag = (CompoundTag)itemTag;
                iB.add((Object)MCHeldItem.fromTag(itemCTag));
            }
            ImmutableList heldItems = iB.build();
            String job = vcTag.m_128461_("job");
            UUID uuid = vcTag.m_128342_("UUID");
            if (job.isEmpty()) {
                QT.JOB_LOGGER.error("Empty job. Falling back to gatherer for {}", (Object)uuid);
                job = "gatherer";
            }
            ImmutableSnapshot<MCHeldItem, ?> journal = ServerJobsRegistry.getNewJournal(ServerJobsRegistry.parseStringValue(job), vcTag.m_128461_("journal_status"), (ImmutableList<MCHeldItem>)heldItems);
            b.add(new TownState.VillagerData<MCHeldItem>(x, y, z, journal, uuid));
        }
        return b.build();
    }

    private ImmutableList<ContainerTarget<MCContainer, MCTownItem>> loadContainers(CompoundTag tag, ServerLevel level) {
        ImmutableList.Builder cB = ImmutableList.builder();
        ListTag containers = tag.m_128437_("containers", 10);
        for (Tag cTag : containers) {
            CompoundTag ccTag = (CompoundTag)cTag;
            ImmutableList.Builder cItems = ImmutableList.builder();
            ListTag items = ccTag.m_128437_("items", 10);
            for (Tag item : items) {
                CompoundTag icTag = (CompoundTag)item;
                ItemStack stack = ItemStack.m_41712_((CompoundTag)icTag.m_128469_("item"));
                cItems.add((Object)MCTownItem.fromMCItemStack(stack));
            }
            int x = ccTag.m_128451_("x");
            int y = ccTag.m_128451_("y");
            int z = ccTag.m_128451_("z");
            BlockPos pos = new BlockPos(x, y, z);
            BlockState bs = level.m_8055_(pos);
            ImmutableList tagItems = cItems.build();
            if (!(bs.m_60734_() instanceof ChestBlock)) {
                TownStateSerializer.logLostItems(pos, (ImmutableList<MCTownItem>)tagItems);
                continue;
            }
            @Nullable ContainerTarget<MCContainer, MCTownItem> ct = TownContainers.fromChestBlock(null, pos, (ChestBlock)bs.m_60734_(), level);
            if (ct == null) {
                TownStateSerializer.logLostItems(pos, (ImmutableList<MCTownItem>)tagItems);
                continue;
            }
            cB.add(ct);
            ImmutableList stateItems = tagItems;
            this.checkItems(ct, (ImmutableList<MCTownItem>)stateItems);
        }
        return cB.build();
    }

    private static void logLostItems(BlockPos pos, ImmutableList<MCTownItem> tagItems) {
        QT.FLAG_LOGGER.error("There used to be a chest at {}, but now there isn't. This may be a bug and may cause these items to be lost: {}", (Object)pos, (Object)Util.toShortString(tagItems.size(), i -> ((MCTownItem)tagItems.get(i.intValue())).toQTItemStack(), false));
    }

    private void checkItems(ContainerTarget ct, ImmutableList<MCTownItem> stateItems) {
        int sSize;
        ImmutableList containerItems = ct.getItems();
        int cSize = containerItems.size();
        if (cSize != (sSize = stateItems.size())) {
            Questown.LOGGER.error("Container items do not match stored state. This is a bug and may cause items to be lost. [{}, {}]", (Object)cSize, (Object)sSize);
        }
        for (int i = 0; i < cSize; ++i) {
            MCTownItem sItem;
            MCTownItem cItem = (MCTownItem)containerItems.get(i);
            if (cItem.equals(sItem = (MCTownItem)stateItems.get(i))) continue;
            Questown.LOGGER.error("In slot {}, expected {} but state had {}. This is a bug and may cause items to be lost.", (Object)i, (Object)cItem, (Object)sItem);
        }
    }

    public static interface GatesGetter {
        public boolean isGateValid(BlockPos var1);
    }
}

