/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.items;

import ca.bradj.questown.QT;
import ca.bradj.questown.Questown;
import ca.bradj.questown.core.init.items.ItemsInit;
import ca.bradj.questown.integration.minecraft.MCHeldItem;
import ca.bradj.questown.items.QTNBT;
import ca.bradj.questown.mc.Compat;
import java.util.Collection;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class GathererMap
extends Item {
    public static final String ITEM_ID = "gatherer_map";

    public GathererMap() {
        super(Questown.DEFAULT_ITEM_PROPS.m_41487_(1));
    }

    @Nullable
    public static ResourceLocation getBiome(ItemStack itemStack) {
        CompoundTag tag = itemStack.m_41784_();
        if (QTNBT.contains(tag, "biome")) {
            return QTNBT.getResourceLocation(tag, "biome");
        }
        return null;
    }

    @Nullable
    public static ResourceLocation computeBiome(Collection<MCHeldItem> items) {
        ResourceLocation biome = null;
        for (MCHeldItem item : items) {
            if (!item.get().get().equals(ItemsInit.GATHERER_MAP.get())) continue;
            biome = GathererMap.getBiome(item.get().toQTItemStack());
            if (biome != null) break;
            QT.JOB_LOGGER.error("No biome tag on gatherer map. Ignoring");
        }
        return biome;
    }

    public void m_7373_(ItemStack p_41421_, @Nullable Level p_41422_, List<Component> tooltips, TooltipFlag p_41424_) {
        super.m_7373_(p_41421_, p_41422_, tooltips, p_41424_);
        ResourceLocation biome = GathererMap.getBiome(p_41421_);
        String biomeName = "(none)";
        if (biome != null) {
            biomeName = biome.toString();
        }
        tooltips.add(Compat.literal("Biome: " + biomeName));
    }
}

