/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.items;

import ca.bradj.questown.Questown;
import ca.bradj.questown.blocks.TownFlagBlock;
import ca.bradj.questown.core.network.OnScreenTextMessage;
import ca.bradj.questown.core.network.QuestownNetwork;
import ca.bradj.questown.gui.CreateStockRequestContainer;
import ca.bradj.questown.jobs.ServerJobsRegistry;
import ca.bradj.questown.jobs.WorksBehaviour;
import ca.bradj.questown.mc.Compat;
import ca.bradj.questown.town.TownFlagBlockEntity;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

public class StockRequestClipboardItem
extends Item {
    public static final String ITEM_ID = "stock_request_clipboard";

    public StockRequestClipboardItem() {
        super(Questown.DEFAULT_ITEM_PROPS);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level lvl, Player player, InteractionHand hand) {
        if (!(player instanceof ServerPlayer)) {
            return super.m_7203_(lvl, player, hand);
        }
        ServerPlayer sp = (ServerPlayer)player;
        ItemStack itemInHand = player.m_21120_(hand);
        TownFlagBlockEntity parent = TownFlagBlock.GetParentFromNBT(sp.m_9236_(), itemInHand);
        if (parent == null) {
            OnScreenTextMessage msg = new OnScreenTextMessage("message.flag_item.no_flag", new Object[0]);
            QuestownNetwork.CHANNEL.send(PacketDistributor.PLAYER.with(() -> sp), (Object)msg);
            return InteractionResultHolder.m_19100_((Object)itemInHand);
        }
        WorksBehaviour.TownData td = parent.getTownData();
        final BlockPos flagPos = parent.getTownFlagBasePos();
        final ImmutableSet<Ingredient> allOutputs = ServerJobsRegistry.getAllOutputs(td);
        Compat.openScreen(sp, new MenuProvider(){

            @NotNull
            public Component m_5446_() {
                return Compat.literal("");
            }

            @NotNull
            public AbstractContainerMenu m_7208_(int windowId, @NotNull Inventory inv, @NotNull Player p) {
                return new CreateStockRequestContainer(windowId, (Collection<Ingredient>)allOutputs, flagPos);
            }
        }, data -> {
            CreateStockRequestContainer.writeWorkResults((ImmutableCollection<Ingredient>)allOutputs, data);
            CreateStockRequestContainer.writeFlagPosition(flagPos, data);
        });
        return InteractionResultHolder.m_19092_((Object)itemInHand, (boolean)false);
    }
}

