/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.items;

import ca.bradj.questown.QT;
import ca.bradj.questown.Questown;
import ca.bradj.questown.blocks.TownFlagBlock;
import ca.bradj.questown.core.Config;
import ca.bradj.questown.items.UseOnContext;
import ca.bradj.questown.mc.Compat;
import ca.bradj.questown.town.TownFlagBlockEntity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TownDoorItem
extends Item {
    public static final String ITEM_ID = "town_door";

    public TownDoorItem() {
        super(Questown.DEFAULT_ITEM_PROPS);
    }

    public InteractionResult m_6225_(net.minecraft.world.item.context.UseOnContext ctx) {
        return TownDoorItem.placeAndRegisterContainedItem(ctx);
    }

    @NotNull
    private static InteractionResult placeAndRegisterContainedItem(net.minecraft.world.item.context.UseOnContext ctx) {
        Level level;
        @Nullable ItemStack input = TownFlagBlock.GetFlagInputFromItemNBT(ctx.m_43722_());
        if (input == null) {
            QT.ITEM_LOGGER.error("{} is missing flag input", (Object)ForgeRegistries.ITEMS.getKey((Object)ctx.m_43722_().m_41720_()));
            return InteractionResult.FAIL;
        }
        InteractionResult interactionResult = input.m_41720_().m_6225_((net.minecraft.world.item.context.UseOnContext)new UseOnContext(ctx, input));
        if (interactionResult.equals((Object)InteractionResult.CONSUME) && (level = ctx.m_43725_()) instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            TownFlagBlockEntity parent = TownFlagBlock.GetParentFromNBT(sl, ctx.m_43722_());
            parent.getRoomHandle().registerDoor(ctx.m_8083_().m_7494_());
        }
        if (!Compat.configGet(Config.INFINITE_TOWN_DOORS).get().booleanValue()) {
            ctx.m_43722_().m_41774_(1);
        }
        return interactionResult;
    }
}

