/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.items;

import ca.bradj.questown.Questown;
import ca.bradj.questown.blocks.FalseDoorBlock;
import ca.bradj.questown.blocks.RoomBlock;
import ca.bradj.questown.blocks.TownFlagBlock;
import ca.bradj.questown.mc.Compat;
import ca.bradj.questown.mc.Util;
import ca.bradj.questown.town.TownFlagBlockEntity;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class TownWand
extends Item {
    public static final String ITEM_ID = "town_wand";
    private static ImmutableList<ClickHandler> handlers = ImmutableList.of((Object)new DoorHandler(), (Object)new GateHandler(), (Object)new RoomBlockHandler());

    public TownWand() {
        super(Questown.DEFAULT_ITEM_PROPS);
    }

    public void onRightClicked(Supplier<ServerPlayer> player, ServerLevel level, BlockPos clickedPos, ItemStack itemInHand) {
        TownFlagBlockEntity parent = TownFlagBlock.GetParentFromNBT(level, itemInHand);
        for (ClickHandler handler : handlers) {
            if (!handler.handle(level, clickedPos, parent)) continue;
            return;
        }
        BlockPos bp = parent.getTownFlagBasePos();
        Util.onScreenText(player, "message.wand.clicked_away", bp.m_123341_(), bp.m_123342_(), bp.m_123343_());
    }

    public InteractionResult m_6225_(UseOnContext p_41427_) {
        InteractionResult x = super.m_6225_(p_41427_);
        if (p_41427_.m_43725_().f_46443_) {
            return InteractionResult.CONSUME;
        }
        ServerLevel level = (ServerLevel)p_41427_.m_43725_();
        for (ClickHandler handler : handlers) {
            if (handler.getEffectivePosition(level, p_41427_.m_8083_()) == null) continue;
            return InteractionResult.CONSUME;
        }
        if (!x.m_19077_()) {
            ItemStack item = p_41427_.m_43722_();
            TownFlagBlockEntity parent = TownFlagBlock.GetParentFromNBT(level, item);
            BlockPos bp = parent.getTownFlagBasePos();
            Util.onScreenText(() -> (ServerPlayer)p_41427_.m_43723_(), "message.wand.clicked_away", bp.m_123341_(), bp.m_123342_(), bp.m_123343_());
        }
        return x;
    }

    public void m_7373_(ItemStack item, @Nullable Level level, List<Component> p_41423_, TooltipFlag p_41424_) {
        super.m_7373_(item, level, p_41423_, p_41424_);
        BlockPos parent = TownFlagBlock.GetParentPosFromNBT(item);
        Style color = Style.f_131099_.m_131148_(TextColor.m_131268_((String)"GRAY"));
        if (parent == null) {
            String key = "tooltips.items.wand.inactive";
            p_41423_.add(Compat.translatableStyled(key, color, new Object[0]));
        } else {
            String key = "tooltips.items.wand.active";
            p_41423_.add(Compat.translatableStyled(key, color, parent.m_123341_(), parent.m_123342_(), parent.m_123343_()));
        }
    }

    private static interface ClickHandler {
        public BlockPos getEffectivePosition(ServerLevel var1, BlockPos var2);

        public boolean handle(ServerLevel var1, BlockPos var2, TownFlagBlockEntity var3);
    }

    private static class DoorHandler
    implements ClickHandler {
        private DoorHandler() {
        }

        @Override
        public BlockPos getEffectivePosition(ServerLevel level, BlockPos clickedPos) {
            BlockState bs = level.m_8055_(clickedPos);
            if (bs.m_60734_() instanceof FalseDoorBlock) {
                return clickedPos;
            }
            if (bs.m_60734_() instanceof DoorBlock) {
                if (DoubleBlockHalf.UPPER.equals((Object)bs.m_61143_((Property)DoorBlock.f_52730_))) {
                    clickedPos = clickedPos.m_7495_();
                }
            } else {
                bs = level.m_8055_(clickedPos.m_7494_());
                if (bs.m_60734_() instanceof DoorBlock) {
                    clickedPos = clickedPos.m_7494_();
                } else {
                    return null;
                }
            }
            return clickedPos;
        }

        @Override
        public boolean handle(ServerLevel level, BlockPos clickedPos, TownFlagBlockEntity parent) {
            BlockPos doorPos = this.getEffectivePosition(level, clickedPos);
            if (doorPos != null) {
                parent.getRoomHandle().registerDoor(doorPos);
                return true;
            }
            return false;
        }
    }

    private static class GateHandler
    implements ClickHandler {
        private GateHandler() {
        }

        @Override
        public BlockPos getEffectivePosition(ServerLevel level, BlockPos clickedPos) {
            BlockState bs = level.m_8055_(clickedPos);
            if (bs.m_60734_() instanceof FenceGateBlock) {
                return clickedPos;
            }
            return null;
        }

        @Override
        public boolean handle(ServerLevel level, BlockPos clickedPos, TownFlagBlockEntity parent) {
            BlockPos doorPos = this.getEffectivePosition(level, clickedPos);
            if (doorPos != null) {
                parent.getRoomHandle().registerFenceGate(doorPos);
                return true;
            }
            return false;
        }
    }

    private static class RoomBlockHandler
    implements ClickHandler {
        private RoomBlockHandler() {
        }

        @Override
        public BlockPos getEffectivePosition(ServerLevel level, BlockPos clickedPos) {
            BlockState bs = level.m_8055_(clickedPos);
            if (bs.m_60734_() instanceof RoomBlock) {
                return clickedPos;
            }
            return null;
        }

        @Override
        public boolean handle(ServerLevel level, BlockPos clickedPos, TownFlagBlockEntity parent) {
            BlockState bs = level.m_8055_(clickedPos);
            Block block = bs.m_60734_();
            if (block instanceof RoomBlock) {
                RoomBlock rb = (RoomBlock)block;
                parent.getRoomHandle().registerBlockAsRoom(RoomBlock.getRoomId(rb), clickedPos);
                return true;
            }
            return false;
        }
    }
}

