/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.jobs;

import ca.bradj.questown.integration.minecraft.MCContainer;
import ca.bradj.questown.integration.minecraft.MCContainerInterface;
import ca.bradj.questown.integration.minecraft.MCTownItem;
import ca.bradj.questown.jobs.leaver.ContainerTarget;
import ca.bradj.questown.town.TownContainers;
import ca.bradj.questown.town.interfaces.TownInterface;
import ca.bradj.roomrecipes.adapter.RoomRecipeMatch;
import ca.bradj.roomrecipes.serialization.MCRoom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import org.jetbrains.annotations.Nullable;

public class Containers {
    public static List<ContainerTarget<MCContainer, MCTownItem>> get(TownInterface town, Predicate<RoomRecipeMatch<MCRoom>> includeRoom, Predicate<BlockPos> isJobBlock, Predicate<ResourceLocation> isJobSite, boolean stopAfterOneFound) {
        @Nullable ServerLevel sl = town.getServerLevel();
        Collection<RoomRecipeMatch<MCRoom>> allContainers = town.getRoomHandle().getMatches(includeRoom);
        ArrayList<ContainerTarget<MCContainer, MCTownItem>> chests = new ArrayList<ContainerTarget<MCContainer, MCTownItem>>();
        for (RoomRecipeMatch<MCRoom> c : allContainers) {
            for (Map.Entry block : c.getContainedBlocks().entrySet()) {
                boolean added;
                boolean containerIsNotJobTarget;
                if (((Block)block.getValue()).equals(Blocks.f_50016_)) continue;
                boolean containerIsNotInJobSite = c.getRecipeIDs().stream().noneMatch(isJobSite);
                boolean bl = containerIsNotJobTarget = !isJobBlock.test((BlockPos)block.getKey());
                if ((containerIsNotInJobSite || containerIsNotJobTarget) && (added = Containers.addIfChest(c, block, sl, chests)) && stopAfterOneFound) {
                    return chests;
                }
                if (!containerIsNotJobTarget || !(added = Containers.addIfContainer(c, block, sl, chests)) || !stopAfterOneFound) continue;
                return chests;
            }
        }
        return chests;
    }

    private static boolean addIfChest(RoomRecipeMatch<MCRoom> c, Map.Entry<BlockPos, Block> block, ServerLevel sl, List<ContainerTarget<MCContainer, MCTownItem>> chests) {
        Block block2 = block.getValue();
        if (!(block2 instanceof ChestBlock)) {
            return false;
        }
        ChestBlock cb = (ChestBlock)block2;
        BlockPos bp = block.getKey();
        ContainerTarget<MCContainer, MCTownItem> chest = TownContainers.fromChestBlock((MCRoom)c.room, bp, cb, sl);
        if (chest == null) {
            return false;
        }
        chests.add(chest);
        return true;
    }

    private static boolean addIfContainer(RoomRecipeMatch<MCRoom> c, Map.Entry<BlockPos, Block> block, ServerLevel sl, List<ContainerTarget<MCContainer, MCTownItem>> chests) {
        BlockPos bp = block.getKey();
        ContainerTarget<MCContainer, MCTownItem> chest = TownContainers.fromEntity(sl, bp);
        if (chest != null) {
            chests.add(chest);
            return true;
        }
        return false;
    }

    public static int addIfPossible(ItemStack itemInHand, MCContainerInterface rack) {
        if (rack.isFull()) {
            return -1;
        }
        if (!rack.canAcceptIfSpaceAllows(MCTownItem.fromMCItemStack(itemInHand))) {
            return -1;
        }
        for (int i = 0; i < rack.size(); ++i) {
            if (!rack.setItem(i, MCTownItem.fromMCItemStack(itemInHand))) continue;
            itemInHand.m_41774_(1);
            return i;
        }
        return -1;
    }
}

