/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.jobs;

import ca.bradj.questown.core.Pair;
import ca.bradj.questown.core.UtilClean;
import ca.bradj.questown.integration.minecraft.MCContainer;
import ca.bradj.questown.integration.minecraft.MCHeldItem;
import ca.bradj.questown.integration.minecraft.MCTownItem;
import ca.bradj.questown.integration.minecraft.MCTownState;
import ca.bradj.questown.jobs.Containers;
import ca.bradj.questown.jobs.EntityLocStateProvider;
import ca.bradj.questown.jobs.HeldItem;
import ca.bradj.questown.jobs.IProductionStatusFactory;
import ca.bradj.questown.jobs.IStatusFactory;
import ca.bradj.questown.jobs.Item;
import ca.bradj.questown.jobs.JobID;
import ca.bradj.questown.jobs.LZCD;
import ca.bradj.questown.jobs.MCTownStateWorldInteraction;
import ca.bradj.questown.jobs.Populated;
import ca.bradj.questown.jobs.SignalSource;
import ca.bradj.questown.jobs.Signals;
import ca.bradj.questown.jobs.SimpleDependency;
import ca.bradj.questown.jobs.WorkOutput;
import ca.bradj.questown.jobs.WorkPosition;
import ca.bradj.questown.jobs.declarative.ProductionJournal;
import ca.bradj.questown.jobs.declarative.WithReason;
import ca.bradj.questown.jobs.leaver.ContainerTarget;
import ca.bradj.questown.jobs.production.ProductionStatus;
import ca.bradj.questown.jobs.production.ProductionStatuses;
import ca.bradj.questown.jobs.production.RoomsNeedingVillagerInput;
import ca.bradj.questown.logic.PredicateCollection;
import ca.bradj.questown.mc.Util;
import ca.bradj.questown.roomrecipes.Spaces;
import ca.bradj.questown.town.Warper;
import ca.bradj.questown.town.interfaces.TownInterface;
import ca.bradj.questown.town.interfaces.WorkStatusHandle;
import ca.bradj.questown.town.workstatus.State;
import ca.bradj.roomrecipes.adapter.Positions;
import ca.bradj.roomrecipes.adapter.RoomRecipeMatch;
import ca.bradj.roomrecipes.core.space.Position;
import ca.bradj.roomrecipes.serialization.MCRoom;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeclarativeJobs {
    public static final IProductionStatusFactory<ProductionStatus> STATUS_FACTORY = new IProductionStatusFactory<ProductionStatus>(){

        @Override
        public ProductionStatus fromJobBlockState(int s) {
            return ProductionStatus.fromJobBlockStatus(s);
        }

        @Override
        public ProductionStatus waitingForTimedState() {
            return ProductionStatus.FACTORY.waitingForTimedState();
        }

        @Override
        public ProductionStatus noWorkPossible() {
            return ProductionStatus.FACTORY.noWorkPossible();
        }

        @Override
        public ProductionStatus droppingLoot() {
            return ProductionStatus.FACTORY.droppingLoot();
        }

        @Override
        public ProductionStatus noSpace() {
            return ProductionStatus.FACTORY.noSpace();
        }

        @Override
        public ProductionStatus goingToJobSite() {
            return ProductionStatus.FACTORY.goingToJobSite();
        }

        @Override
        public ProductionStatus noJobSite() {
            return ProductionStatus.FACTORY.noJobSite();
        }

        @Override
        public ProductionStatus noSupplies() {
            return ProductionStatus.FACTORY.noSupplies();
        }

        @Override
        public ProductionStatus collectingSupplies() {
            return ProductionStatus.FACTORY.collectingSupplies();
        }

        @Override
        public ProductionStatus idle() {
            return ProductionStatus.FACTORY.idle();
        }

        @Override
        public ProductionStatus extractingProduct() {
            return ProductionStatus.FACTORY.extractingProduct();
        }

        @Override
        public ProductionStatus relaxing() {
            return ProductionStatus.FACTORY.relaxing();
        }
    };
    private static ImmutableMap<ProductionStatus, Function<HandlerInputs, MCTownState>> handler;

    public static <INGREDIENT, ITEM extends Item<ITEM>, HELD_ITEM extends HeldItem<HELD_ITEM, ITEM>> Map<Integer, Boolean> getSupplyItemStatus(Collection<HELD_ITEM> journalItems, ImmutableMap<Integer, INGREDIENT> ingredientsRequiredAtStates, ImmutableMap<Integer, INGREDIENT> toolsRequiredAtStates, BiPredicate<INGREDIENT, HELD_ITEM> matchFn) {
        HashMap b = new HashMap();
        BiConsumer<Integer, Object> fn = (state, ingr) -> {
            if (ingr == null) {
                if (!b.containsKey(state)) {
                    b.put(state, false);
                }
                return;
            }
            boolean has = journalItems.stream().anyMatch(v -> matchFn.test(ingr, v));
            if (!b.getOrDefault(state, false).booleanValue()) {
                b.put(state, has);
            }
        };
        ingredientsRequiredAtStates.forEach(fn);
        toolsRequiredAtStates.forEach(fn);
        return ImmutableMap.copyOf(b);
    }

    public static BiFunction<Integer, SignalSource, ProductionJournal<MCTownItem, MCHeldItem>> journalInitializer(JobID jobId) {
        return (capacity, signalSource) -> new ProductionJournal(jobId, (SignalSource)signalSource, (int)capacity, MCHeldItem::Air, (IStatusFactory<ProductionStatus>)STATUS_FACTORY);
    }

    public static ImmutableMap<Integer, RoomsWithWorkableStatefulBlocks> rooms(@NotNull Integer maxState, RoomsNeedingVillagerInput<MCRoom, ResourceLocation, BlockPos> roomHandle, WorkStatusHandle<BlockPos, MCHeldItem> work, Predicate<BlockPos> isJobBlock) {
        ImmutableMap.Builder b = ImmutableMap.builder();
        Supplier<Rooms> e = () -> {
            ImmutableMap.Builder spotStatuses = ImmutableMap.builder();
            ImmutableMap.Builder spotJBs = ImmutableMap.builder();
            HashMap roomStatuses = new HashMap();
            Stream<RoomsNeedingVillagerInput.NVIRoom> rooms = roomHandle.getMatches().stream();
            rooms = rooms.filter(v -> !v.dueToWorkOnly());
            rooms.forEach(match -> {
                for (Map.Entry entry : match.room().getContainedBlocks().entrySet()) {
                    BlockPos bp = (BlockPos)entry.getKey();
                    State jobBlockState = work.getJobBlockState(bp);
                    if (jobBlockState == null) continue;
                    int v = jobBlockState.processingState();
                    spotStatuses.put((Object)bp, (Object)v);
                    UtilClean.addOrInitializeList(roomStatuses, (MCRoom)match.room().getRoom(), v);
                    spotJBs.put((Object)bp, (Object)isJobBlock.test(bp));
                }
            });
            return new Rooms((Map<BlockPos, Integer>)spotStatuses.build(), roomStatuses, (Map<BlockPos, Boolean>)spotJBs.build());
        };
        for (int i = 0; i < maxState; ++i) {
            b.put((Object)i, (Object)new RoomsWithWorkableStatefulBlocks(i, e));
        }
        return b.build();
    }

    public static LZCD.Dependency<Void> supplies(ServerLevel level, final Supplier<? extends Map<Integer, ? extends LZCD.Dependency<Void>>> roomsHaveWorkableBlocks, final TownInterface rooms, final Map<Integer, PredicateCollection<MCHeldItem, MCHeldItem>> ingredients, final Map<Integer, PredicateCollection<MCTownItem, MCTownItem>> tools, final Predicate<RoomRecipeMatch<MCRoom>> shouldGetSuppliesFromRoom, final Predicate<BlockPos> isJobBlock, final Predicate<ResourceLocation> isJobSite) {
        return new SimpleDependency("town has supplies"){

            @Override
            public String describe() {
                return "TODO";
            }

            @Override
            protected Populated<WithReason<Boolean>> doPopulate(boolean stopOnTrue) {
                ImmutableMap.Builder b = ImmutableMap.builder();
                Map needs = (Map)roomsHaveWorkableBlocks.get();
                b.put((Object)"room needs", (Object)needs);
                ArrayList<PredicateCollection> neededIngredients = new ArrayList<PredicateCollection>();
                ArrayList<PredicateCollection> neededTools = new ArrayList<PredicateCollection>();
                for (Map.Entry v : needs.entrySet()) {
                    PredicateCollection predicateCollection;
                    Integer state = (Integer)v.getKey();
                    if (!((Boolean)((WithReason)((LZCD.Dependency)v.getValue()).apply((Supplier<Void>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$doPopulate$0(), ()Ljava/lang/Void;)())).value).booleanValue()) continue;
                    PredicateCollection ingt = (PredicateCollection)ingredients.get(state);
                    if (ingt != null) {
                        neededIngredients.add(ingt);
                    }
                    if ((predicateCollection = (PredicateCollection)tools.get(state)) == null) continue;
                    neededTools.add(predicateCollection);
                }
                b.put((Object)"relevant ingredients", neededIngredients);
                b.put((Object)"relevant tools", neededTools);
                List<ContainerTarget<MCContainer, MCTownItem>> containers = Containers.get(rooms, shouldGetSuppliesFromRoom, isJobBlock, isJobSite, false);
                b.put((Object)"containers", containers);
                WithReason<Boolean> found = null;
                HashMap<String, Pair<String, String>> b2 = new HashMap<String, Pair<String, String>>();
                for (ContainerTarget containerTarget : containers) {
                    Position position = Positions.FromBlockPos((BlockPos)containerTarget.getBlockPos());
                    String dPos = position.getUIString();
                    for (MCTownItem i : containerTarget.getItems()) {
                        if (i.isEmpty() || b2.get(dPos) != null && Boolean.TRUE.equals(b2.get(dPos))) continue;
                        MCHeldItem iHeld = MCHeldItem.fromTown(i);
                        Optional<PredicateCollection> matchedIngredient = neededIngredients.stream().filter(ing -> ing.test(iHeld)).findFirst();
                        String result = matchedIngredient.map(Object::toString).orElse("No match");
                        b2.put(dPos, new Pair<String, String>(result, containerTarget.toShortString(false)));
                        if (matchedIngredient.isPresent()) {
                            found = WithReason.always(true, i.getShortName() + " matches " + String.valueOf(matchedIngredient.get()), new Object[0]);
                            if (stopOnTrue) break;
                        }
                        Optional<PredicateCollection> matchedTool = neededTools.stream().filter(ing -> ing.test(i)).findFirst();
                        result = matchedTool.map(Object::toString).orElse("No match");
                        b2.put(dPos, new Pair<String, String>(result, containerTarget.toShortString(false)));
                        if (!matchedTool.isPresent()) continue;
                        found = WithReason.always(true, i.getShortName() + " matches " + String.valueOf(matchedTool.get()), new Object[0]);
                        if (!stopOnTrue) continue;
                        break;
                    }
                    if (found == null || !stopOnTrue) continue;
                    break;
                }
                if (found == null) {
                    found = WithReason.always(false, "No matches found for " + String.valueOf(ingredients) + " in any containers", new Object[0]);
                }
                b.put((Object)"supply checks", (Object)ImmutableMap.copyOf(b2));
                b.put((Object)"predicate", (Object)ingredients);
                final ImmutableMap build = b.build();
                return new Populated<WithReason<Boolean>>("town has supplies", found, (Map)build, null){

                    @Override
                    protected String stringRep() {
                        return "town has supplies [" + String.valueOf(build) + "]";
                    }
                };
            }

            private static /* synthetic */ Void lambda$doPopulate$0() {
                return null;
            }
        };
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static void staticInitialize() {
        // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable ImmutableMap.Builder b = ImmutableMap.builder();
        Function<HandlerInputs, @Nullable MCTownState> tryWorking = ii -> {
            @Nullable WorkOutput<TOWN, @Nullable WorkPosition<BlockPos>> v = ii.wi.tryWorking(ii.inState, new WorkPosition<BlockPos>(ii.fakePos, ii.fakePos));
            if (v == null) {
                return null;
            }
            return (MCTownState)v.town();
        };
        for (int i2 = 0; i2 < 10; ++i2) {
            b.put((Object)ProductionStatus.fromJobBlockStatus(i2), ii -> {
                if (!ii.status.isWorkingOnProduction()) {
                    return ii.inState.town();
                }
                return (MCTownState)tryWorking.apply((HandlerInputs)ii);
            });
        }
        b.put((Object)ProductionStatus.EXTRACTING_PRODUCT, tryWorking);
        b.put((Object)ProductionStatus.DROPPING_LOOT, i -> i.wi.simulateDropLoot(i.inState.town(), i.status));
        b.put((Object)ProductionStatus.COLLECTING_SUPPLIES, i -> i.wi.simulateCollectSupplies(i.inState.town(), i.workBlockState.processingState()));
        b.put((Object)ProductionStatus.RELAXING, i -> null);
        b.put((Object)ProductionStatus.WAITING_FOR_TIMED_STATE, i -> null);
        b.put((Object)ProductionStatus.NO_SPACE, i -> null);
        b.put((Object)ProductionStatus.GOING_TO_JOB, i -> null);
        b.put((Object)ProductionStatus.NO_SUPPLIES, i -> null);
        b.put((Object)ProductionStatus.IDLE, i -> null);
        b.put((Object)ProductionStatus.NO_JOBSITE, i -> null);
        handler = b.build();
    }

    public static Warper<ServerLevel, MCTownState> warper(final MCTownStateWorldInteraction wi, final int maxState, final boolean prioritizeExtraction) {
        ImmutableSet<ProductionStatus> productionStatuses;
        ImmutableSet c = handler.keySet();
        if (!c.containsAll(productionStatuses = ProductionStatus.allStatuses())) {
            throw new IllegalStateException("Not all production states are handled. Difference: " + String.valueOf(Sets.difference((Set)ImmutableSet.copyOf(productionStatuses), (Set)ImmutableSet.copyOf((Collection)c))));
        }
        return new Warper<ServerLevel, MCTownState>(){

            @Override
            public MCTownState warp(ServerLevel level, MCTownState inState, long currentTick, long ticksPassed, int villagerNum) {
                MCTownState affectedState;
                BlockPos fakePos = new BlockPos(villagerNum, villagerNum, villagerNum);
                MCTownState outState = inState;
                State state = (State)outState.workStates.get((Object)fakePos);
                if (state == null) {
                    outState = (MCTownState)outState.setJobBlockState(fakePos, State.fresh());
                }
                ProductionStatus status = ProductionStatus.FACTORY.idle();
                State ztate = (State)outState.workStates.get((Object)fakePos);
                MCTownStateWorldInteraction.Inputs fState = new MCTownStateWorldInteraction.Inputs(outState, level, inState.getVillager((int)villagerNum).uuid);
                wi.injectTicks((int)ticksPassed);
                MCRoom fakeRoom = Spaces.metaRoomAround(fakePos, 1);
                @Nullable ProductionStatus nuStatus = ProductionStatuses.getNewStatusFromSignal(status, Signals.fromDayTime(Util.getDayTime((Level)level)), wi.asInventory(() -> wi.getHeldItems(fState, villagerNum), ztate::processingState), wi.asTownJobs(ztate, (RoomRecipeMatch<MCRoom>)new RoomRecipeMatch((Object)fakeRoom, ImmutableList.of((Object)new ResourceLocation("fake")), (Iterable)ImmutableList.of()), fakePos, (ImmutableList<ContainerTarget<MCContainer, MCTownItem>>)outState.containers), DeclarativeJobs.alwaysInRoom(fakeRoom), STATUS_FACTORY, prioritizeExtraction);
                if (nuStatus != null) {
                    status = nuStatus;
                }
                if ((affectedState = (MCTownState)((Function)handler.get((Object)status)).apply(new HandlerInputs(wi, fState, status, ztate, maxState, fakePos))) != null) {
                    outState = affectedState;
                }
                outState = (MCTownState)outState.withTimerReducedBy(fakePos, (int)ticksPassed);
                return outState;
            }

            @Override
            public Collection<Warper.Tick> getTicks(long referenceTick, long ticksPassed) {
                ImmutableList.Builder b = ImmutableList.builder();
                long start = referenceTick;
                long max = referenceTick + ticksPassed;
                int workInterval = wi.interval * 2;
                int stepInterval = Math.max(workInterval, 100);
                for (long i = start; i <= max; i += (long)stepInterval) {
                    b.add((Object)new Warper.Tick(i, stepInterval));
                }
                return b.build();
            }
        };
    }

    private static EntityLocStateProvider<MCRoom> alwaysInRoom(final MCRoom fakeRoom) {
        return new EntityLocStateProvider<MCRoom>(){

            @Override
            @Nullable
            public MCRoom getEntityCurrentJobSite() {
                return fakeRoom;
            }
        };
    }

    public static final class RoomsWithWorkableStatefulBlocks
    implements LZCD.Dependency<Void> {
        private static final String NAME = "rooms contain workable blocks with state";
        private final Supplier<Rooms> inputs;
        private final String name;
        private final int state;
        private Populated<WithReason<Boolean>> value;

        public RoomsWithWorkableStatefulBlocks(int state, Supplier<Rooms> inputs) {
            this.inputs = inputs;
            this.name = "rooms contain workable blocks with state " + state;
            this.state = state;
        }

        @Override
        public Populated<WithReason<@Nullable Boolean>> populate() {
            Rooms v = this.inputs.get();
            Map<BlockPos, Integer> spotStates = v.spotStatuses();
            List<Map.Entry> spotsWithMatchingState = spotStates.entrySet().stream().filter(z -> this.state == (Integer)z.getValue()).toList();
            List<Map.Entry> spotsThatAreJobBlocks = v.spotJobBlocks().entrySet().stream().filter(Map.Entry::getValue).toList();
            Optional<Map.Entry> foundSpot = spotsWithMatchingState.stream().filter(z -> spotsThatAreJobBlocks.stream().anyMatch(vv -> ((BlockPos)vv.getKey()).equals(z.getKey()))).findFirst();
            WithReason<Boolean> hasSpot = foundSpot.map(zz -> WithReason.always(true, "town has workable spot with state at " + String.valueOf(((Map.Entry)foundSpot.get()).getKey()), new Object[0])).orElse(WithReason.always(false, "no spots found", new Object[0]));
            ImmutableMap.Builder css = ImmutableMap.builder();
            spotStates.forEach((k, vv) -> css.put((Object)k.m_123344_(), vv));
            ImmutableMap.Builder cjs = ImmutableMap.builder();
            v.spotJobBlocks().forEach((k, vv) -> cjs.put((Object)k.m_123344_(), vv));
            ImmutableMap.Builder crs = ImmutableMap.builder();
            v.roomStatuses().forEach((k, vv) -> crs.put((Object)k.doorPos.getUIString(), vv));
            ImmutableMap bSpots = css.build();
            ImmutableMap jBlocks = cjs.build();
            final ImmutableMap bRooms = crs.build();
            this.value = new Populated<WithReason<Boolean>>(this.name, hasSpot, (Map)ImmutableMap.of((Object)"spots", (Object)bSpots, (Object)"rooms", (Object)bRooms, (Object)"job_blocks", (Object)jBlocks), null){

                @Override
                protected String stringRep() {
                    return "RoomsWithState=[" + String.valueOf(bRooms) + "]";
                }
            };
            return this.value;
        }

        @Override
        public String describe() {
            return "RoomsContainWorkState=" + String.valueOf(this.value.value());
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public WithReason<Boolean> apply(Supplier<Void> voidSupplier) {
            return this.populate().value();
        }

        public String toString() {
            return this.describe();
        }
    }

    private record HandlerInputs(MCTownStateWorldInteraction wi, MCTownStateWorldInteraction.Inputs inState, ProductionStatus status, State workBlockState, Integer maxState, BlockPos fakePos) {
    }

    public record Rooms(Map<BlockPos, Integer> spotStatuses, Map<MCRoom, ? extends Collection<Integer>> roomStatuses, Map<BlockPos, Boolean> spotJobBlocks) {
    }
}

