/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.jobs;

import ca.bradj.questown.jobs.HeldItem;
import ca.bradj.questown.jobs.InventoryStateProvider;
import ca.bradj.questown.jobs.Item;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableCollection;

public class DefaultInventoryStateProvider<I extends HeldItem<I, ?>>
implements InventoryStateProvider<I> {
    private final CurrentItemsSource<I> itemsSource;

    public DefaultInventoryStateProvider(CurrentItemsSource<I> itemsSource) {
        this.itemsSource = itemsSource;
    }

    @Override
    public boolean hasAnyDroppableLoot() {
        if (!this.isValid()) {
            throw new IllegalStateException("Inventory must be size 6");
        }
        return this.itemsSource.GetCurrentItems().stream().anyMatch(Predicates.and((Predicate[])new Predicate[]{Predicates.not(Item::isFood), Predicates.not(Item::isEmpty), Predicates.not(HeldItem::isLocked)}));
    }

    @Override
    public boolean inventoryIsFull() {
        if (!this.isValid()) {
            throw new IllegalStateException("Inventory must be size 6");
        }
        return this.itemsSource.GetCurrentItems().stream().noneMatch(Item::isEmpty);
    }

    public boolean inventoryIsEmpty() {
        if (!this.isValid()) {
            throw new IllegalStateException("Inventory must be size 6");
        }
        return this.itemsSource.GetCurrentItems().stream().allMatch(Item::isEmpty);
    }

    @Override
    public boolean inventoryHasFood() {
        if (!this.isValid()) {
            throw new IllegalStateException("Inventory must be size 6");
        }
        return this.itemsSource.GetCurrentItems().stream().anyMatch(Item::isFood);
    }

    @Override
    public boolean hasAnyItems() {
        if (!this.isValid()) {
            throw new IllegalStateException("Inventory must be size 6");
        }
        return this.itemsSource.GetCurrentItems().stream().anyMatch(Predicates.not(Item::isEmpty));
    }

    @Override
    public boolean isValid() {
        return this.itemsSource.GetCurrentItems().size() == 6;
    }

    public static interface CurrentItemsSource<I extends HeldItem<I, ?>> {
        public ImmutableCollection<I> GetCurrentItems();
    }
}

