/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.jobs;

import ca.bradj.questown.core.Config;
import ca.bradj.questown.jobs.JobID;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public class ExpirationRules {
    private final Supplier<Long> maxInitialTicksWithoutSupplies;
    private final Supplier<Long> maxTicksWithoutSupplies;
    private final Function<JobID, JobID> noSuppliesFallbackFn;
    private final Supplier<Long> maxTicks;
    private final Function<JobID, JobID> maxTicksFallbackFn;
    @Nullable
    private Long realizedInitTicks;
    @Nullable
    private Long realizedTicks;
    @Nullable
    private Long realizedSupplyTicks;

    public ExpirationRules(Supplier<Long> maxInitialTicksWithoutSupplies, Supplier<Long> maxTicksWithoutSupplies, Function<JobID, JobID> noSuppliesFallbackFn, Supplier<Long> maxTicks, Function<JobID, JobID> maxTicksFallbackFn) {
        this.maxInitialTicksWithoutSupplies = maxInitialTicksWithoutSupplies;
        this.maxTicksWithoutSupplies = maxTicksWithoutSupplies;
        this.noSuppliesFallbackFn = noSuppliesFallbackFn;
        this.maxTicks = maxTicks;
        this.maxTicksFallbackFn = maxTicksFallbackFn;
    }

    public static ExpirationRules never() {
        return new ExpirationRules(() -> Config.MAX_INITIAL_TICKS_WITHOUT_SUPPLIES.get(), () -> Config.MAX_TICKS_WITHOUT_SUPPLIES.get(), jobID -> jobID, () -> 3000L, jobID -> jobID);
    }

    public long maxTicks() {
        if (this.realizedTicks == null) {
            this.realizedTicks = this.maxTicks.get();
        }
        return this.realizedTicks;
    }

    public Function<JobID, JobID> maxTicksFallbackFn() {
        return this.maxTicksFallbackFn;
    }

    public long maxTicksWithoutSuppliesOrJobSite() {
        if (this.realizedSupplyTicks == null) {
            this.realizedSupplyTicks = this.maxTicksWithoutSupplies.get();
        }
        return this.realizedSupplyTicks;
    }

    public long maxInitialTicksWithoutSuppliesOrJobSite() {
        if (this.realizedInitTicks == null) {
            this.realizedInitTicks = this.maxInitialTicksWithoutSupplies.get();
        }
        return this.realizedInitTicks;
    }

    public Function<JobID, JobID> noSuppliesFallbackFn() {
        return this.noSuppliesFallbackFn;
    }

    public ExpirationRules withInitialNoSupplyTickLimit(long i) {
        return new ExpirationRules(() -> i, this.maxTicksWithoutSupplies, this.noSuppliesFallbackFn, this.maxTicks, this.maxTicksFallbackFn);
    }

    public ExpirationRules withNoSupplyTickLimit(long i) {
        return new ExpirationRules(this.maxInitialTicksWithoutSupplies, () -> i, this.noSuppliesFallbackFn, this.maxTicks, this.maxTicksFallbackFn);
    }
}

