/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.jobs;

import java.util.Collection;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import org.jetbrains.annotations.Nullable;

public record JobID(String rootId, String jobId) {
    @Nullable
    public static JobID fromJSON(@Nullable String val) {
        if (val == null) {
            return null;
        }
        String[] split = val.split("/");
        if (split.length != 2) {
            String msg = String.format("Invalid JobID %s. Format should match \"<job_id>/<work_id>\"", val);
            throw new IllegalArgumentException(msg);
        }
        return new JobID(split[0], split[1]);
    }

    public static JobID fromTag(CompoundTag v) {
        return new JobID(v.m_128461_("root"), v.m_128461_("jobId"));
    }

    public static Tag toTag(JobID jobID) {
        CompoundTag ct = new CompoundTag();
        ct.m_128359_("root", jobID.rootId);
        ct.m_128359_("jobId", jobID.jobId);
        return ct;
    }

    public static Tag toTag(Collection<JobID> jobIDS) {
        ListTag lt = new ListTag();
        for (JobID jobID : jobIDS) {
            lt.add((Object)JobID.toTag(jobID));
        }
        return lt;
    }

    @Override
    public String toString() {
        return "JobID{rootId='" + this.rootId + "', jobId='" + this.jobId + "'}";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JobID jobID = (JobID)o;
        return Objects.equals(this.rootId, jobID.rootId) && Objects.equals(this.jobId, jobID.jobId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.rootId, this.jobId);
    }

    public String toNiceString() {
        return String.format("%s:%s", this.rootId, this.jobId);
    }

    public boolean sameRoot(JobID other) {
        return this.rootId.equals(other.rootId);
    }
}

